/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionReference> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionId").getter(ExecutionReference.getter(ExecutionReference::executionId)).setter(ExecutionReference.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<ExecutionStatus> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionStatus").getter(ExecutionReference.getter(ExecutionReference::executionStatus)).setter(ExecutionReference.setter(Builder::executionStatus)).constructor(ExecutionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, EXECUTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionId;
    private final ExecutionStatus executionStatus;

    private ExecutionReference(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.executionStatus = builder.executionStatus;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final ExecutionStatus executionStatus() {
        return this.executionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionReference)) {
            return false;
        }
        ExecutionReference other = (ExecutionReference)obj;
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.executionStatus(), other.executionStatus());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionReference").add("ExecutionId", (Object)this.executionId()).add("ExecutionStatus", (Object)this.executionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "ExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionReference, T> g) {
        return obj -> g.apply((ExecutionReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionId;
        private ExecutionStatus executionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionReference model) {
            this.executionId(model.executionId);
            this.executionStatus(model.executionStatus);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final ExecutionStatus.Builder getExecutionStatus() {
            return this.executionStatus != null ? this.executionStatus.toBuilder() : null;
        }

        public final void setExecutionStatus(ExecutionStatus.BuilderImpl executionStatus) {
            this.executionStatus = executionStatus != null ? executionStatus.build() : null;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public ExecutionReference build() {
            return new ExecutionReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionReference> {
        public Builder executionId(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        default public Builder executionStatus(Consumer<ExecutionStatus.Builder> executionStatus) {
            return this.executionStatus((ExecutionStatus)((ExecutionStatus.Builder)ExecutionStatus.builder().applyMutation(executionStatus)).build());
        }
    }
}

