/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmdashboards.model.DateTimeRange;
import software.amazon.awssdk.services.bcmdashboards.model.Expression;
import software.amazon.awssdk.services.bcmdashboards.model.Granularity;
import software.amazon.awssdk.services.bcmdashboards.model.GroupDefinition;
import software.amazon.awssdk.services.bcmdashboards.model.GroupDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationUtilizationQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationUtilizationQuery> {
    private static final SdkField<DateTimeRange> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeRange").getter(ReservationUtilizationQuery.getter(ReservationUtilizationQuery::timeRange)).setter(ReservationUtilizationQuery.setter(Builder::timeRange)).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()}).build();
    private static final SdkField<List<GroupDefinition>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupBy").getter(ReservationUtilizationQuery.getter(ReservationUtilizationQuery::groupBy)).setter(ReservationUtilizationQuery.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("granularity").getter(ReservationUtilizationQuery.getter(ReservationUtilizationQuery::granularityAsString)).setter(ReservationUtilizationQuery.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("granularity").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ReservationUtilizationQuery.getter(ReservationUtilizationQuery::filter)).setter(ReservationUtilizationQuery.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD, GROUP_BY_FIELD, GRANULARITY_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservationUtilizationQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DateTimeRange timeRange;
    private final List<GroupDefinition> groupBy;
    private final String granularity;
    private final Expression filter;

    private ReservationUtilizationQuery(BuilderImpl builder) {
        this.timeRange = builder.timeRange;
        this.groupBy = builder.groupBy;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
    }

    public final DateTimeRange timeRange() {
        return this.timeRange;
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<GroupDefinition> groupBy() {
        return this.groupBy;
    }

    public final Granularity granularity() {
        return Granularity.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final Expression filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationUtilizationQuery)) {
            return false;
        }
        ReservationUtilizationQuery other = (ReservationUtilizationQuery)obj;
        return Objects.equals(this.timeRange(), other.timeRange()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupBy(), other.groupBy()) && Objects.equals(this.granularityAsString(), other.granularityAsString()) && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"ReservationUtilizationQuery").add("TimeRange", (Object)this.timeRange()).add("GroupBy", this.hasGroupBy() ? this.groupBy() : null).add("Granularity", (Object)this.granularityAsString()).add("Filter", (Object)this.filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRange()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeRange", TIME_RANGE_FIELD);
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("granularity", GRANULARITY_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservationUtilizationQuery, T> g) {
        return obj -> g.apply((ReservationUtilizationQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DateTimeRange timeRange;
        private List<GroupDefinition> groupBy = DefaultSdkAutoConstructList.getInstance();
        private String granularity;
        private Expression filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationUtilizationQuery model) {
            this.timeRange(model.timeRange);
            this.groupBy(model.groupBy);
            this.granularity(model.granularity);
            this.filter(model.filter);
        }

        public final DateTimeRange.Builder getTimeRange() {
            return this.timeRange != null ? this.timeRange.toBuilder() : null;
        }

        public final void setTimeRange(DateTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(DateTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupBy() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<GroupDefinition.BuilderImpl> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<GroupDefinition> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupDefinition ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<GroupDefinition.Builder> ... groupBy) {
            this.groupBy(Stream.of(groupBy).map(c -> (GroupDefinition)((GroupDefinition.Builder)GroupDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public ReservationUtilizationQuery build() {
            return new ReservationUtilizationQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationUtilizationQuery> {
        public Builder timeRange(DateTimeRange var1);

        default public Builder timeRange(Consumer<DateTimeRange.Builder> timeRange) {
            return this.timeRange((DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation(timeRange)).build());
        }

        public Builder groupBy(Collection<GroupDefinition> var1);

        public Builder groupBy(GroupDefinition ... var1);

        public Builder groupBy(Consumer<GroupDefinition.Builder> ... var1);

        public Builder granularity(String var1);

        public Builder granularity(Granularity var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }
    }
}

