/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DateTimeType {
    ABSOLUTE("ABSOLUTE"),
    RELATIVE("RELATIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DateTimeType> VALUE_MAP;
    private final String value;

    private DateTimeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DateTimeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DateTimeType> knownValues() {
        EnumSet<DateTimeType> knownValues = EnumSet.allOf(DateTimeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DateTimeType.class, DateTimeType::toString);
    }
}

