/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmdashboards.model.WidgetConfig;
import software.amazon.awssdk.services.bcmdashboards.model.WidgetConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Widget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Widget> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Widget.getter(Widget::title)).setter(Widget.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Widget.getter(Widget::description)).setter(Widget.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("width").getter(Widget.getter(Widget::width)).setter(Widget.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("height").getter(Widget.getter(Widget::height)).setter(Widget.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()}).build();
    private static final SdkField<Integer> HORIZONTAL_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("horizontalOffset").getter(Widget.getter(Widget::horizontalOffset)).setter(Widget.setter(Builder::horizontalOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("horizontalOffset").build()}).build();
    private static final SdkField<List<WidgetConfig>> CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configs").getter(Widget.getter(Widget::configs)).setter(Widget.setter(Builder::configs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WidgetConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, DESCRIPTION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, HORIZONTAL_OFFSET_FIELD, CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Widget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String description;
    private final Integer width;
    private final Integer height;
    private final Integer horizontalOffset;
    private final List<WidgetConfig> configs;

    private Widget(BuilderImpl builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.width = builder.width;
        this.height = builder.height;
        this.horizontalOffset = builder.horizontalOffset;
        this.configs = builder.configs;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final Integer width() {
        return this.width;
    }

    public final Integer height() {
        return this.height;
    }

    public final Integer horizontalOffset() {
        return this.horizontalOffset;
    }

    public final boolean hasConfigs() {
        return this.configs != null && !(this.configs instanceof SdkAutoConstructList);
    }

    public final List<WidgetConfig> configs() {
        return this.configs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.horizontalOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigs() ? this.configs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Widget)) {
            return false;
        }
        Widget other = (Widget)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.horizontalOffset(), other.horizontalOffset()) && this.hasConfigs() == other.hasConfigs() && Objects.equals(this.configs(), other.configs());
    }

    public final String toString() {
        return ToString.builder((String)"Widget").add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Width", (Object)this.width()).add("Height", (Object)this.height()).add("HorizontalOffset", (Object)this.horizontalOffset()).add("Configs", this.hasConfigs() ? this.configs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "horizontalOffset": {
                return Optional.ofNullable(clazz.cast(this.horizontalOffset()));
            }
            case "configs": {
                return Optional.ofNullable(clazz.cast(this.configs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("width", WIDTH_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("horizontalOffset", HORIZONTAL_OFFSET_FIELD);
        map.put("configs", CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Widget, T> g) {
        return obj -> g.apply((Widget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String description;
        private Integer width;
        private Integer height;
        private Integer horizontalOffset;
        private List<WidgetConfig> configs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Widget model) {
            this.title(model.title);
            this.description(model.description);
            this.width(model.width);
            this.height(model.height);
            this.horizontalOffset(model.horizontalOffset);
            this.configs(model.configs);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Integer getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public final void setHorizontalOffset(Integer horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
        }

        @Override
        public final Builder horizontalOffset(Integer horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            return this;
        }

        public final List<WidgetConfig.Builder> getConfigs() {
            List<WidgetConfig.Builder> result = WidgetConfigListCopier.copyToBuilder(this.configs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigs(Collection<WidgetConfig.BuilderImpl> configs) {
            this.configs = WidgetConfigListCopier.copyFromBuilder(configs);
        }

        @Override
        public final Builder configs(Collection<WidgetConfig> configs) {
            this.configs = WidgetConfigListCopier.copy(configs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configs(WidgetConfig ... configs) {
            this.configs(Arrays.asList(configs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configs(Consumer<WidgetConfig.Builder> ... configs) {
            this.configs(Stream.of(configs).map(c -> (WidgetConfig)((WidgetConfig.Builder)WidgetConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Widget build() {
            return new Widget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Widget> {
        public Builder title(String var1);

        public Builder description(String var1);

        public Builder width(Integer var1);

        public Builder height(Integer var1);

        public Builder horizontalOffset(Integer var1);

        public Builder configs(Collection<WidgetConfig> var1);

        public Builder configs(WidgetConfig ... var1);

        public Builder configs(Consumer<WidgetConfig.Builder> ... var1);
    }
}

