/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VisualType {
    LINE("LINE"),
    BAR("BAR"),
    STACK("STACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VisualType> VALUE_MAP;
    private final String value;

    private VisualType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VisualType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VisualType> knownValues() {
        EnumSet<VisualType> knownValues = EnumSet.allOf(VisualType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VisualType.class, VisualType::toString);
    }
}

