/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmdashboards.model.GraphDisplayConfig;
import software.amazon.awssdk.services.bcmdashboards.model.GraphDisplayConfigMapCopier;
import software.amazon.awssdk.services.bcmdashboards.model.TableDisplayConfigStruct;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisplayConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DisplayConfig> {
    private static final SdkField<Map<String, GraphDisplayConfig>> GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("graph").getter(DisplayConfig.getter(DisplayConfig::graph)).setter(DisplayConfig.setter(Builder::graph)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graph").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GraphDisplayConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TableDisplayConfigStruct> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("table").getter(DisplayConfig.getter(DisplayConfig::table)).setter(DisplayConfig.setter(Builder::table)).constructor(TableDisplayConfigStruct::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("table").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_FIELD, TABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisplayConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, GraphDisplayConfig> graph;
    private final TableDisplayConfigStruct table;
    private final Type type;

    private DisplayConfig(BuilderImpl builder) {
        this.graph = builder.graph;
        this.table = builder.table;
        this.type = builder.type;
    }

    public final boolean hasGraph() {
        return this.graph != null && !(this.graph instanceof SdkAutoConstructMap);
    }

    public final Map<String, GraphDisplayConfig> graph() {
        return this.graph;
    }

    public final TableDisplayConfigStruct table() {
        return this.table;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGraph() ? this.graph() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisplayConfig)) {
            return false;
        }
        DisplayConfig other = (DisplayConfig)obj;
        return this.hasGraph() == other.hasGraph() && Objects.equals(this.graph(), other.graph()) && Objects.equals(this.table(), other.table());
    }

    public final String toString() {
        return ToString.builder((String)"DisplayConfig").add("Graph", this.hasGraph() ? this.graph() : null).add("Table", (Object)this.table()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graph": {
                return Optional.ofNullable(clazz.cast(this.graph()));
            }
            case "table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
        }
        return Optional.empty();
    }

    public static DisplayConfig fromGraph(Map<String, GraphDisplayConfig> graph) {
        return (DisplayConfig)DisplayConfig.builder().graph(graph).build();
    }

    public static DisplayConfig fromTable(TableDisplayConfigStruct table) {
        return (DisplayConfig)DisplayConfig.builder().table(table).build();
    }

    public static DisplayConfig fromTable(Consumer<TableDisplayConfigStruct.Builder> table) {
        TableDisplayConfigStruct.Builder builder = TableDisplayConfigStruct.builder();
        table.accept(builder);
        return DisplayConfig.fromTable((TableDisplayConfigStruct)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graph", GRAPH_FIELD);
        map.put("table", TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisplayConfig, T> g) {
        return obj -> g.apply((DisplayConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GRAPH,
        TABLE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, GraphDisplayConfig> graph = DefaultSdkAutoConstructMap.getInstance();
        private TableDisplayConfigStruct table;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DisplayConfig model) {
            this.graph(model.graph);
            this.table(model.table);
        }

        public final Map<String, GraphDisplayConfig.Builder> getGraph() {
            Map<String, GraphDisplayConfig.Builder> result = GraphDisplayConfigMapCopier.copyToBuilder(this.graph);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setGraph(Map<String, GraphDisplayConfig.BuilderImpl> graph) {
            Map<String, GraphDisplayConfig> oldValue = this.graph;
            this.graph = GraphDisplayConfigMapCopier.copyFromBuilder(graph);
            this.handleUnionValueChange(Type.GRAPH, oldValue, this.graph);
        }

        @Override
        public final Builder graph(Map<String, GraphDisplayConfig> graph) {
            Map<String, GraphDisplayConfig> oldValue = this.graph;
            this.graph = GraphDisplayConfigMapCopier.copy(graph);
            this.handleUnionValueChange(Type.GRAPH, oldValue, this.graph);
            return this;
        }

        public final TableDisplayConfigStruct.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(TableDisplayConfigStruct.BuilderImpl table) {
            TableDisplayConfigStruct oldValue = this.table;
            this.table = table != null ? table.build() : null;
            this.handleUnionValueChange(Type.TABLE, oldValue, this.table);
        }

        @Override
        public final Builder table(TableDisplayConfigStruct table) {
            TableDisplayConfigStruct oldValue = this.table;
            this.table = table;
            this.handleUnionValueChange(Type.TABLE, oldValue, this.table);
            return this;
        }

        public DisplayConfig build() {
            return new DisplayConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DisplayConfig> {
        public Builder graph(Map<String, GraphDisplayConfig> var1);

        public Builder table(TableDisplayConfigStruct var1);

        default public Builder table(Consumer<TableDisplayConfigStruct.Builder> table) {
            return this.table((TableDisplayConfigStruct)((TableDisplayConfigStruct.Builder)TableDisplayConfigStruct.builder().applyMutation(table)).build());
        }
    }
}

