/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bcmdashboards.model.CreateDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.CreateDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.model.GetDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.GetDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.bcmdashboards.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest;
import software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsResponse;
import software.amazon.awssdk.services.bcmdashboards.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmdashboards.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmdashboards.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmdashboards.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmdashboards.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmdashboards.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmdashboards.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.paginators.ListDashboardsPublisher;

/**
 * Service client for accessing AWS Billing and Cost Management Dashboards asynchronously. This can be created using the
 * static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Web Services Billing and Cost Management Dashboards is a service that enables you to create, manage, and share
 * dashboards that combine multiple visualizations of your Amazon Web Services cost and usage data. You can combine
 * multiple data sources including Cost Explorer, Savings Plans, and Reserved Instance metrics into unified dashboards,
 * helping you analyze spending patterns and share cost insights across your organization.
 * </p>
 * <p>
 * You can use the Amazon Web Services Billing and Cost Management Dashboards API to programmatically create, manage,
 * and share dashboards. This includes creating custom dashboards, configuring widgets, managing dashboard permissions,
 * and sharing dashboards across accounts in your organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BcmDashboardsAsyncClient extends AwsClient {
    String SERVICE_NAME = "bcm-dashboards";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bcm-dashboards";

    /**
     * <p>
     * Creates a new dashboard that can contain multiple widgets displaying cost and usage data. You can add custom
     * widgets or use predefined widgets, arranging them in your preferred layout.
     * </p>
     *
     * @param createDashboardRequest
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ServiceQuotaExceededException The request would exceed service quotas. For example, attempting to
     *         create more than 20 widgets in a dashboard or exceeding the maximum number of dashboards per account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/CreateDashboard"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new dashboard that can contain multiple widgets displaying cost and usage data. You can add custom
     * widgets or use predefined widgets, arranging them in your preferred layout.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDashboardRequest#builder()}
     * </p>
     *
     * @param createDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.CreateDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ServiceQuotaExceededException The request would exceed service quotas. For example, attempting to
     *         create more than 20 widgets in a dashboard or exceeding the maximum number of dashboards per account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/CreateDashboard"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(
            Consumer<CreateDashboardRequest.Builder> createDashboardRequest) {
        return createDashboard(CreateDashboardRequest.builder().applyMutation(createDashboardRequest).build());
    }

    /**
     * <p>
     * Deletes a specified dashboard. This action cannot be undone.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/DeleteDashboard"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified dashboard. This action cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDashboardRequest#builder()}
     * </p>
     *
     * @param deleteDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.DeleteDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/DeleteDashboard"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(
            Consumer<DeleteDashboardRequest.Builder> deleteDashboardRequest) {
        return deleteDashboard(DeleteDashboardRequest.builder().applyMutation(deleteDashboardRequest).build());
    }

    /**
     * <p>
     * Retrieves the configuration and metadata of a specified dashboard, including its widgets and layout settings.
     * </p>
     *
     * @param getDashboardRequest
     * @return A Java Future containing the result of the GetDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.GetDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/GetDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDashboardResponse> getDashboard(GetDashboardRequest getDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration and metadata of a specified dashboard, including its widgets and layout settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDashboardRequest.Builder} avoiding the need to
     * create one manually via {@link GetDashboardRequest#builder()}
     * </p>
     *
     * @param getDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.GetDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.GetDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/GetDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDashboardResponse> getDashboard(Consumer<GetDashboardRequest.Builder> getDashboardRequest) {
        return getDashboard(GetDashboardRequest.builder().applyMutation(getDashboardRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to a dashboard, showing sharing configurations and permissions.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to a dashboard, showing sharing configurations and permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns a list of all dashboards in your account.
     * </p>
     *
     * @param listDashboardsRequest
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all dashboards in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) {
        return listDashboards(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmdashboards.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmdashboards.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest)} operation.</b>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsPublisher listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest) {
        return new ListDashboardsPublisher(this, listDashboardsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmdashboards.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmdashboards.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsPublisher listDashboardsPaginator(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) {
        return listDashboardsPaginator(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all tags associated with a specified dashboard resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all tags associated with a specified dashboard resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a specified dashboard resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a specified dashboard resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specified tags from a dashboard resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified tags from a dashboard resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing dashboard's properties, including its name, description, and widget configurations.
     * </p>
     *
     * @param updateDashboardRequest
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/UpdateDashboard"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest updateDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing dashboard's properties, including its name, description, and widget configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDashboardRequest#builder()}
     * </p>
     *
     * @param updateDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmdashboards.model.UpdateDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling. Reduce the frequency of
     *         requests and use exponential backoff.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Verify your IAM
     *         permissions and any resource policies.</li>
     *         <li>InternalServerException An internal error occurred while processing the request. Retry your request.
     *         If the problem persists, contact Amazon Web Services Support.</li>
     *         <li>ValidationException The input parameters do not satisfy the requirements. Check the error message for
     *         specific validation details.</li>
     *         <li>ResourceNotFoundException The specified resource (dashboard, policy, or widget) was not found. Verify
     *         the ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmDashboardsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BcmDashboardsAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/UpdateDashboard"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(
            Consumer<UpdateDashboardRequest.Builder> updateDashboardRequest) {
        return updateDashboard(UpdateDashboardRequest.builder().applyMutation(updateDashboardRequest).build());
    }

    @Override
    default BcmDashboardsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BcmDashboardsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BcmDashboardsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BcmDashboardsAsyncClient}.
     */
    static BcmDashboardsAsyncClientBuilder builder() {
        return new DefaultBcmDashboardsAsyncClientBuilder();
    }
}
