/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the data retrieval parameters for a widget.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryParameters implements SdkPojo, Serializable, ToCopyableBuilder<QueryParameters.Builder, QueryParameters> {
    private static final SdkField<CostAndUsageQuery> COST_AND_USAGE_FIELD = SdkField
            .<CostAndUsageQuery> builder(MarshallingType.SDK_POJO).memberName("costAndUsage")
            .getter(getter(QueryParameters::costAndUsage)).setter(setter(Builder::costAndUsage))
            .constructor(CostAndUsageQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costAndUsage").build()).build();

    private static final SdkField<SavingsPlansCoverageQuery> SAVINGS_PLANS_COVERAGE_FIELD = SdkField
            .<SavingsPlansCoverageQuery> builder(MarshallingType.SDK_POJO).memberName("savingsPlansCoverage")
            .getter(getter(QueryParameters::savingsPlansCoverage)).setter(setter(Builder::savingsPlansCoverage))
            .constructor(SavingsPlansCoverageQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlansCoverage").build())
            .build();

    private static final SdkField<SavingsPlansUtilizationQuery> SAVINGS_PLANS_UTILIZATION_FIELD = SdkField
            .<SavingsPlansUtilizationQuery> builder(MarshallingType.SDK_POJO).memberName("savingsPlansUtilization")
            .getter(getter(QueryParameters::savingsPlansUtilization)).setter(setter(Builder::savingsPlansUtilization))
            .constructor(SavingsPlansUtilizationQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlansUtilization").build())
            .build();

    private static final SdkField<ReservationCoverageQuery> RESERVATION_COVERAGE_FIELD = SdkField
            .<ReservationCoverageQuery> builder(MarshallingType.SDK_POJO).memberName("reservationCoverage")
            .getter(getter(QueryParameters::reservationCoverage)).setter(setter(Builder::reservationCoverage))
            .constructor(ReservationCoverageQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationCoverage").build())
            .build();

    private static final SdkField<ReservationUtilizationQuery> RESERVATION_UTILIZATION_FIELD = SdkField
            .<ReservationUtilizationQuery> builder(MarshallingType.SDK_POJO).memberName("reservationUtilization")
            .getter(getter(QueryParameters::reservationUtilization)).setter(setter(Builder::reservationUtilization))
            .constructor(ReservationUtilizationQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationUtilization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_AND_USAGE_FIELD,
            SAVINGS_PLANS_COVERAGE_FIELD, SAVINGS_PLANS_UTILIZATION_FIELD, RESERVATION_COVERAGE_FIELD,
            RESERVATION_UTILIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CostAndUsageQuery costAndUsage;

    private final SavingsPlansCoverageQuery savingsPlansCoverage;

    private final SavingsPlansUtilizationQuery savingsPlansUtilization;

    private final ReservationCoverageQuery reservationCoverage;

    private final ReservationUtilizationQuery reservationUtilization;

    private final Type type;

    private QueryParameters(BuilderImpl builder) {
        this.costAndUsage = builder.costAndUsage;
        this.savingsPlansCoverage = builder.savingsPlansCoverage;
        this.savingsPlansUtilization = builder.savingsPlansUtilization;
        this.reservationCoverage = builder.reservationCoverage;
        this.reservationUtilization = builder.reservationUtilization;
        this.type = builder.type;
    }

    /**
     * <p>
     * The parameters for querying cost and usage data, including metrics, time range, granularity, grouping dimensions,
     * and filters.
     * </p>
     * 
     * @return The parameters for querying cost and usage data, including metrics, time range, granularity, grouping
     *         dimensions, and filters.
     */
    public final CostAndUsageQuery costAndUsage() {
        return costAndUsage;
    }

    /**
     * <p>
     * The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage is
     * covered by Savings Plans.
     * </p>
     * 
     * @return The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage
     *         is covered by Savings Plans.
     */
    public final SavingsPlansCoverageQuery savingsPlansCoverage() {
        return savingsPlansCoverage;
    }

    /**
     * <p>
     * The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans are being
     * used.
     * </p>
     * 
     * @return The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans
     *         are being used.
     */
    public final SavingsPlansUtilizationQuery savingsPlansUtilization() {
        return savingsPlansUtilization;
    }

    /**
     * <p>
     * The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance usage is
     * covered by Reserved Instances.
     * </p>
     * 
     * @return The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance
     *         usage is covered by Reserved Instances.
     */
    public final ReservationCoverageQuery reservationCoverage() {
        return reservationCoverage;
    }

    /**
     * <p>
     * The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved Instances
     * are being used.
     * </p>
     * 
     * @return The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved
     *         Instances are being used.
     */
    public final ReservationUtilizationQuery reservationUtilization() {
        return reservationUtilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costAndUsage());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(reservationCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(reservationUtilization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryParameters)) {
            return false;
        }
        QueryParameters other = (QueryParameters) obj;
        return Objects.equals(costAndUsage(), other.costAndUsage())
                && Objects.equals(savingsPlansCoverage(), other.savingsPlansCoverage())
                && Objects.equals(savingsPlansUtilization(), other.savingsPlansUtilization())
                && Objects.equals(reservationCoverage(), other.reservationCoverage())
                && Objects.equals(reservationUtilization(), other.reservationUtilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryParameters").add("CostAndUsage", costAndUsage())
                .add("SavingsPlansCoverage", savingsPlansCoverage()).add("SavingsPlansUtilization", savingsPlansUtilization())
                .add("ReservationCoverage", reservationCoverage()).add("ReservationUtilization", reservationUtilization())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "costAndUsage":
            return Optional.ofNullable(clazz.cast(costAndUsage()));
        case "savingsPlansCoverage":
            return Optional.ofNullable(clazz.cast(savingsPlansCoverage()));
        case "savingsPlansUtilization":
            return Optional.ofNullable(clazz.cast(savingsPlansUtilization()));
        case "reservationCoverage":
            return Optional.ofNullable(clazz.cast(reservationCoverage()));
        case "reservationUtilization":
            return Optional.ofNullable(clazz.cast(reservationUtilization()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #costAndUsage()} initialized to the given value.
     *
     * <p>
     * The parameters for querying cost and usage data, including metrics, time range, granularity, grouping dimensions,
     * and filters.
     * </p>
     * 
     * @param costAndUsage
     *        The parameters for querying cost and usage data, including metrics, time range, granularity, grouping
     *        dimensions, and filters.
     */
    public static QueryParameters fromCostAndUsage(CostAndUsageQuery costAndUsage) {
        return builder().costAndUsage(costAndUsage).build();
    }

    /**
     * Create an instance of this class with {@link #costAndUsage()} initialized to the given value.
     *
     * <p>
     * The parameters for querying cost and usage data, including metrics, time range, granularity, grouping dimensions,
     * and filters.
     * </p>
     * 
     * @param costAndUsage
     *        The parameters for querying cost and usage data, including metrics, time range, granularity, grouping
     *        dimensions, and filters.
     */
    public static QueryParameters fromCostAndUsage(Consumer<CostAndUsageQuery.Builder> costAndUsage) {
        CostAndUsageQuery.Builder builder = CostAndUsageQuery.builder();
        costAndUsage.accept(builder);
        return fromCostAndUsage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #savingsPlansCoverage()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage is
     * covered by Savings Plans.
     * </p>
     * 
     * @param savingsPlansCoverage
     *        The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage
     *        is covered by Savings Plans.
     */
    public static QueryParameters fromSavingsPlansCoverage(SavingsPlansCoverageQuery savingsPlansCoverage) {
        return builder().savingsPlansCoverage(savingsPlansCoverage).build();
    }

    /**
     * Create an instance of this class with {@link #savingsPlansCoverage()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage is
     * covered by Savings Plans.
     * </p>
     * 
     * @param savingsPlansCoverage
     *        The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage
     *        is covered by Savings Plans.
     */
    public static QueryParameters fromSavingsPlansCoverage(Consumer<SavingsPlansCoverageQuery.Builder> savingsPlansCoverage) {
        SavingsPlansCoverageQuery.Builder builder = SavingsPlansCoverageQuery.builder();
        savingsPlansCoverage.accept(builder);
        return fromSavingsPlansCoverage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #savingsPlansUtilization()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans are being
     * used.
     * </p>
     * 
     * @param savingsPlansUtilization
     *        The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans are
     *        being used.
     */
    public static QueryParameters fromSavingsPlansUtilization(SavingsPlansUtilizationQuery savingsPlansUtilization) {
        return builder().savingsPlansUtilization(savingsPlansUtilization).build();
    }

    /**
     * Create an instance of this class with {@link #savingsPlansUtilization()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans are being
     * used.
     * </p>
     * 
     * @param savingsPlansUtilization
     *        The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans are
     *        being used.
     */
    public static QueryParameters fromSavingsPlansUtilization(
            Consumer<SavingsPlansUtilizationQuery.Builder> savingsPlansUtilization) {
        SavingsPlansUtilizationQuery.Builder builder = SavingsPlansUtilizationQuery.builder();
        savingsPlansUtilization.accept(builder);
        return fromSavingsPlansUtilization(builder.build());
    }

    /**
     * Create an instance of this class with {@link #reservationCoverage()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance usage is
     * covered by Reserved Instances.
     * </p>
     * 
     * @param reservationCoverage
     *        The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance
     *        usage is covered by Reserved Instances.
     */
    public static QueryParameters fromReservationCoverage(ReservationCoverageQuery reservationCoverage) {
        return builder().reservationCoverage(reservationCoverage).build();
    }

    /**
     * Create an instance of this class with {@link #reservationCoverage()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance usage is
     * covered by Reserved Instances.
     * </p>
     * 
     * @param reservationCoverage
     *        The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance
     *        usage is covered by Reserved Instances.
     */
    public static QueryParameters fromReservationCoverage(Consumer<ReservationCoverageQuery.Builder> reservationCoverage) {
        ReservationCoverageQuery.Builder builder = ReservationCoverageQuery.builder();
        reservationCoverage.accept(builder);
        return fromReservationCoverage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #reservationUtilization()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved Instances
     * are being used.
     * </p>
     * 
     * @param reservationUtilization
     *        The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved
     *        Instances are being used.
     */
    public static QueryParameters fromReservationUtilization(ReservationUtilizationQuery reservationUtilization) {
        return builder().reservationUtilization(reservationUtilization).build();
    }

    /**
     * Create an instance of this class with {@link #reservationUtilization()} initialized to the given value.
     *
     * <p>
     * The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved Instances
     * are being used.
     * </p>
     * 
     * @param reservationUtilization
     *        The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved
     *        Instances are being used.
     */
    public static QueryParameters fromReservationUtilization(Consumer<ReservationUtilizationQuery.Builder> reservationUtilization) {
        ReservationUtilizationQuery.Builder builder = ReservationUtilizationQuery.builder();
        reservationUtilization.accept(builder);
        return fromReservationUtilization(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("costAndUsage", COST_AND_USAGE_FIELD);
        map.put("savingsPlansCoverage", SAVINGS_PLANS_COVERAGE_FIELD);
        map.put("savingsPlansUtilization", SAVINGS_PLANS_UTILIZATION_FIELD);
        map.put("reservationCoverage", RESERVATION_COVERAGE_FIELD);
        map.put("reservationUtilization", RESERVATION_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryParameters, T> g) {
        return obj -> g.apply((QueryParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryParameters> {
        /**
         * <p>
         * The parameters for querying cost and usage data, including metrics, time range, granularity, grouping
         * dimensions, and filters.
         * </p>
         * 
         * @param costAndUsage
         *        The parameters for querying cost and usage data, including metrics, time range, granularity, grouping
         *        dimensions, and filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costAndUsage(CostAndUsageQuery costAndUsage);

        /**
         * <p>
         * The parameters for querying cost and usage data, including metrics, time range, granularity, grouping
         * dimensions, and filters.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAndUsageQuery.Builder} avoiding the
         * need to create one manually via {@link CostAndUsageQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAndUsageQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #costAndUsage(CostAndUsageQuery)}.
         * 
         * @param costAndUsage
         *        a consumer that will call methods on {@link CostAndUsageQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costAndUsage(CostAndUsageQuery)
         */
        default Builder costAndUsage(Consumer<CostAndUsageQuery.Builder> costAndUsage) {
            return costAndUsage(CostAndUsageQuery.builder().applyMutation(costAndUsage).build());
        }

        /**
         * <p>
         * The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage is
         * covered by Savings Plans.
         * </p>
         * 
         * @param savingsPlansCoverage
         *        The parameters for querying Savings Plans coverage data, showing how much of your eligible compute
         *        usage is covered by Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansCoverage(SavingsPlansCoverageQuery savingsPlansCoverage);

        /**
         * <p>
         * The parameters for querying Savings Plans coverage data, showing how much of your eligible compute usage is
         * covered by Savings Plans.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsPlansCoverageQuery.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansCoverageQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansCoverageQuery.Builder#build()} is called immediately
         * and its result is passed to {@link #savingsPlansCoverage(SavingsPlansCoverageQuery)}.
         * 
         * @param savingsPlansCoverage
         *        a consumer that will call methods on {@link SavingsPlansCoverageQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansCoverage(SavingsPlansCoverageQuery)
         */
        default Builder savingsPlansCoverage(Consumer<SavingsPlansCoverageQuery.Builder> savingsPlansCoverage) {
            return savingsPlansCoverage(SavingsPlansCoverageQuery.builder().applyMutation(savingsPlansCoverage).build());
        }

        /**
         * <p>
         * The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans are
         * being used.
         * </p>
         * 
         * @param savingsPlansUtilization
         *        The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans
         *        are being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansUtilization(SavingsPlansUtilizationQuery savingsPlansUtilization);

        /**
         * <p>
         * The parameters for querying Savings Plans utilization data, showing how effectively your Savings Plans are
         * being used.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsPlansUtilizationQuery.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansUtilizationQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansUtilizationQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #savingsPlansUtilization(SavingsPlansUtilizationQuery)}.
         * 
         * @param savingsPlansUtilization
         *        a consumer that will call methods on {@link SavingsPlansUtilizationQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansUtilization(SavingsPlansUtilizationQuery)
         */
        default Builder savingsPlansUtilization(Consumer<SavingsPlansUtilizationQuery.Builder> savingsPlansUtilization) {
            return savingsPlansUtilization(SavingsPlansUtilizationQuery.builder().applyMutation(savingsPlansUtilization).build());
        }

        /**
         * <p>
         * The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance usage
         * is covered by Reserved Instances.
         * </p>
         * 
         * @param reservationCoverage
         *        The parameters for querying Reserved Instance coverage data, showing how much of your eligible
         *        instance usage is covered by Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationCoverage(ReservationCoverageQuery reservationCoverage);

        /**
         * <p>
         * The parameters for querying Reserved Instance coverage data, showing how much of your eligible instance usage
         * is covered by Reserved Instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservationCoverageQuery.Builder}
         * avoiding the need to create one manually via {@link ReservationCoverageQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationCoverageQuery.Builder#build()} is called immediately
         * and its result is passed to {@link #reservationCoverage(ReservationCoverageQuery)}.
         * 
         * @param reservationCoverage
         *        a consumer that will call methods on {@link ReservationCoverageQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationCoverage(ReservationCoverageQuery)
         */
        default Builder reservationCoverage(Consumer<ReservationCoverageQuery.Builder> reservationCoverage) {
            return reservationCoverage(ReservationCoverageQuery.builder().applyMutation(reservationCoverage).build());
        }

        /**
         * <p>
         * The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved
         * Instances are being used.
         * </p>
         * 
         * @param reservationUtilization
         *        The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved
         *        Instances are being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationUtilization(ReservationUtilizationQuery reservationUtilization);

        /**
         * <p>
         * The parameters for querying Reserved Instance utilization data, showing how effectively your Reserved
         * Instances are being used.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservationUtilizationQuery.Builder}
         * avoiding the need to create one manually via {@link ReservationUtilizationQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationUtilizationQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #reservationUtilization(ReservationUtilizationQuery)}.
         * 
         * @param reservationUtilization
         *        a consumer that will call methods on {@link ReservationUtilizationQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationUtilization(ReservationUtilizationQuery)
         */
        default Builder reservationUtilization(Consumer<ReservationUtilizationQuery.Builder> reservationUtilization) {
            return reservationUtilization(ReservationUtilizationQuery.builder().applyMutation(reservationUtilization).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CostAndUsageQuery costAndUsage;

        private SavingsPlansCoverageQuery savingsPlansCoverage;

        private SavingsPlansUtilizationQuery savingsPlansUtilization;

        private ReservationCoverageQuery reservationCoverage;

        private ReservationUtilizationQuery reservationUtilization;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(QueryParameters model) {
            costAndUsage(model.costAndUsage);
            savingsPlansCoverage(model.savingsPlansCoverage);
            savingsPlansUtilization(model.savingsPlansUtilization);
            reservationCoverage(model.reservationCoverage);
            reservationUtilization(model.reservationUtilization);
        }

        public final CostAndUsageQuery.Builder getCostAndUsage() {
            return costAndUsage != null ? costAndUsage.toBuilder() : null;
        }

        public final void setCostAndUsage(CostAndUsageQuery.BuilderImpl costAndUsage) {
            Object oldValue = this.costAndUsage;
            this.costAndUsage = costAndUsage != null ? costAndUsage.build() : null;
            handleUnionValueChange(Type.COST_AND_USAGE, oldValue, this.costAndUsage);
        }

        @Override
        public final Builder costAndUsage(CostAndUsageQuery costAndUsage) {
            Object oldValue = this.costAndUsage;
            this.costAndUsage = costAndUsage;
            handleUnionValueChange(Type.COST_AND_USAGE, oldValue, this.costAndUsage);
            return this;
        }

        public final SavingsPlansCoverageQuery.Builder getSavingsPlansCoverage() {
            return savingsPlansCoverage != null ? savingsPlansCoverage.toBuilder() : null;
        }

        public final void setSavingsPlansCoverage(SavingsPlansCoverageQuery.BuilderImpl savingsPlansCoverage) {
            Object oldValue = this.savingsPlansCoverage;
            this.savingsPlansCoverage = savingsPlansCoverage != null ? savingsPlansCoverage.build() : null;
            handleUnionValueChange(Type.SAVINGS_PLANS_COVERAGE, oldValue, this.savingsPlansCoverage);
        }

        @Override
        public final Builder savingsPlansCoverage(SavingsPlansCoverageQuery savingsPlansCoverage) {
            Object oldValue = this.savingsPlansCoverage;
            this.savingsPlansCoverage = savingsPlansCoverage;
            handleUnionValueChange(Type.SAVINGS_PLANS_COVERAGE, oldValue, this.savingsPlansCoverage);
            return this;
        }

        public final SavingsPlansUtilizationQuery.Builder getSavingsPlansUtilization() {
            return savingsPlansUtilization != null ? savingsPlansUtilization.toBuilder() : null;
        }

        public final void setSavingsPlansUtilization(SavingsPlansUtilizationQuery.BuilderImpl savingsPlansUtilization) {
            Object oldValue = this.savingsPlansUtilization;
            this.savingsPlansUtilization = savingsPlansUtilization != null ? savingsPlansUtilization.build() : null;
            handleUnionValueChange(Type.SAVINGS_PLANS_UTILIZATION, oldValue, this.savingsPlansUtilization);
        }

        @Override
        public final Builder savingsPlansUtilization(SavingsPlansUtilizationQuery savingsPlansUtilization) {
            Object oldValue = this.savingsPlansUtilization;
            this.savingsPlansUtilization = savingsPlansUtilization;
            handleUnionValueChange(Type.SAVINGS_PLANS_UTILIZATION, oldValue, this.savingsPlansUtilization);
            return this;
        }

        public final ReservationCoverageQuery.Builder getReservationCoverage() {
            return reservationCoverage != null ? reservationCoverage.toBuilder() : null;
        }

        public final void setReservationCoverage(ReservationCoverageQuery.BuilderImpl reservationCoverage) {
            Object oldValue = this.reservationCoverage;
            this.reservationCoverage = reservationCoverage != null ? reservationCoverage.build() : null;
            handleUnionValueChange(Type.RESERVATION_COVERAGE, oldValue, this.reservationCoverage);
        }

        @Override
        public final Builder reservationCoverage(ReservationCoverageQuery reservationCoverage) {
            Object oldValue = this.reservationCoverage;
            this.reservationCoverage = reservationCoverage;
            handleUnionValueChange(Type.RESERVATION_COVERAGE, oldValue, this.reservationCoverage);
            return this;
        }

        public final ReservationUtilizationQuery.Builder getReservationUtilization() {
            return reservationUtilization != null ? reservationUtilization.toBuilder() : null;
        }

        public final void setReservationUtilization(ReservationUtilizationQuery.BuilderImpl reservationUtilization) {
            Object oldValue = this.reservationUtilization;
            this.reservationUtilization = reservationUtilization != null ? reservationUtilization.build() : null;
            handleUnionValueChange(Type.RESERVATION_UTILIZATION, oldValue, this.reservationUtilization);
        }

        @Override
        public final Builder reservationUtilization(ReservationUtilizationQuery reservationUtilization) {
            Object oldValue = this.reservationUtilization;
            this.reservationUtilization = reservationUtilization;
            handleUnionValueChange(Type.RESERVATION_UTILIZATION, oldValue, this.reservationUtilization);
            return this;
        }

        @Override
        public QueryParameters build() {
            return new QueryParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see QueryParameters#type()
     */
    public enum Type {
        COST_AND_USAGE,

        SAVINGS_PLANS_COVERAGE,

        SAVINGS_PLANS_UTILIZATION,

        RESERVATION_COVERAGE,

        RESERVATION_UTILIZATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
