/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a time period with explicit start and end times for data queries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimeRange implements SdkPojo, Serializable, ToCopyableBuilder<DateTimeRange.Builder, DateTimeRange> {
    private static final SdkField<DateTimeValue> START_TIME_FIELD = SdkField.<DateTimeValue> builder(MarshallingType.SDK_POJO)
            .memberName("startTime").getter(getter(DateTimeRange::startTime)).setter(setter(Builder::startTime))
            .constructor(DateTimeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<DateTimeValue> END_TIME_FIELD = SdkField.<DateTimeValue> builder(MarshallingType.SDK_POJO)
            .memberName("endTime").getter(getter(DateTimeRange::endTime)).setter(setter(Builder::endTime))
            .constructor(DateTimeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DateTimeValue startTime;

    private final DateTimeValue endTime;

    private DateTimeRange(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The start time of the date range for querying data.
     * </p>
     * 
     * @return The start time of the date range for querying data.
     */
    public final DateTimeValue startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the date range for querying data.
     * </p>
     * 
     * @return The end time of the date range for querying data.
     */
    public final DateTimeValue endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRange)) {
            return false;
        }
        DateTimeRange other = (DateTimeRange) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimeRange").add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateTimeRange, T> g) {
        return obj -> g.apply((DateTimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimeRange> {
        /**
         * <p>
         * The start time of the date range for querying data.
         * </p>
         * 
         * @param startTime
         *        The start time of the date range for querying data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(DateTimeValue startTime);

        /**
         * <p>
         * The start time of the date range for querying data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeValue.Builder} avoiding the need
         * to create one manually via {@link DateTimeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #startTime(DateTimeValue)}.
         * 
         * @param startTime
         *        a consumer that will call methods on {@link DateTimeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTime(DateTimeValue)
         */
        default Builder startTime(Consumer<DateTimeValue.Builder> startTime) {
            return startTime(DateTimeValue.builder().applyMutation(startTime).build());
        }

        /**
         * <p>
         * The end time of the date range for querying data.
         * </p>
         * 
         * @param endTime
         *        The end time of the date range for querying data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(DateTimeValue endTime);

        /**
         * <p>
         * The end time of the date range for querying data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeValue.Builder} avoiding the need
         * to create one manually via {@link DateTimeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #endTime(DateTimeValue)}.
         * 
         * @param endTime
         *        a consumer that will call methods on {@link DateTimeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endTime(DateTimeValue)
         */
        default Builder endTime(Consumer<DateTimeValue.Builder> endTime) {
            return endTime(DateTimeValue.builder().applyMutation(endTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DateTimeValue startTime;

        private DateTimeValue endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeRange model) {
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final DateTimeValue.Builder getStartTime() {
            return startTime != null ? startTime.toBuilder() : null;
        }

        public final void setStartTime(DateTimeValue.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        public final Builder startTime(DateTimeValue startTime) {
            this.startTime = startTime;
            return this;
        }

        public final DateTimeValue.Builder getEndTime() {
            return endTime != null ? endTime.toBuilder() : null;
        }

        public final void setEndTime(DateTimeValue.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        @Override
        public final Builder endTime(DateTimeValue endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public DateTimeRange build() {
            return new DateTimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
