/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines how the widget's data should be visualized, including chart type, color schemes, axis configurations, and
 * other display preferences.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisplayConfig implements SdkPojo, Serializable, ToCopyableBuilder<DisplayConfig.Builder, DisplayConfig> {
    private static final SdkField<Map<String, GraphDisplayConfig>> GRAPH_FIELD = SdkField
            .<Map<String, GraphDisplayConfig>> builder(MarshallingType.MAP)
            .memberName("graph")
            .getter(getter(DisplayConfig::graph))
            .setter(setter(Builder::graph))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graph").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<GraphDisplayConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(GraphDisplayConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TableDisplayConfigStruct> TABLE_FIELD = SdkField
            .<TableDisplayConfigStruct> builder(MarshallingType.SDK_POJO).memberName("table")
            .getter(getter(DisplayConfig::table)).setter(setter(Builder::table)).constructor(TableDisplayConfigStruct::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("table").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_FIELD, TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, GraphDisplayConfig> graph;

    private final TableDisplayConfigStruct table;

    private final Type type;

    private DisplayConfig(BuilderImpl builder) {
        this.graph = builder.graph;
        this.table = builder.table;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Graph property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGraph() {
        return graph != null && !(graph instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration for graphical display of the widget data, including chart type and visual options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGraph} method.
     * </p>
     * 
     * @return The configuration for graphical display of the widget data, including chart type and visual options.
     */
    public final Map<String, GraphDisplayConfig> graph() {
        return graph;
    }

    /**
     * <p>
     * The configuration for tabular display of the widget data.
     * </p>
     * 
     * @return The configuration for tabular display of the widget data.
     */
    public final TableDisplayConfigStruct table() {
        return table;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGraph() ? graph() : null);
        hashCode = 31 * hashCode + Objects.hashCode(table());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisplayConfig)) {
            return false;
        }
        DisplayConfig other = (DisplayConfig) obj;
        return hasGraph() == other.hasGraph() && Objects.equals(graph(), other.graph()) && Objects.equals(table(), other.table());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisplayConfig").add("Graph", hasGraph() ? graph() : null).add("Table", table()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graph":
            return Optional.ofNullable(clazz.cast(graph()));
        case "table":
            return Optional.ofNullable(clazz.cast(table()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #graph()} initialized to the given value.
     *
     * <p>
     * The configuration for graphical display of the widget data, including chart type and visual options.
     * </p>
     * 
     * @param graph
     *        The configuration for graphical display of the widget data, including chart type and visual options.
     */
    public static DisplayConfig fromGraph(Map<String, GraphDisplayConfig> graph) {
        return builder().graph(graph).build();
    }

    /**
     * Create an instance of this class with {@link #table()} initialized to the given value.
     *
     * <p>
     * The configuration for tabular display of the widget data.
     * </p>
     * 
     * @param table
     *        The configuration for tabular display of the widget data.
     */
    public static DisplayConfig fromTable(TableDisplayConfigStruct table) {
        return builder().table(table).build();
    }

    /**
     * Create an instance of this class with {@link #table()} initialized to the given value.
     *
     * <p>
     * The configuration for tabular display of the widget data.
     * </p>
     * 
     * @param table
     *        The configuration for tabular display of the widget data.
     */
    public static DisplayConfig fromTable(Consumer<TableDisplayConfigStruct.Builder> table) {
        TableDisplayConfigStruct.Builder builder = TableDisplayConfigStruct.builder();
        table.accept(builder);
        return fromTable(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graph", GRAPH_FIELD);
        map.put("table", TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisplayConfig, T> g) {
        return obj -> g.apply((DisplayConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisplayConfig> {
        /**
         * <p>
         * The configuration for graphical display of the widget data, including chart type and visual options.
         * </p>
         * 
         * @param graph
         *        The configuration for graphical display of the widget data, including chart type and visual options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graph(Map<String, GraphDisplayConfig> graph);

        /**
         * <p>
         * The configuration for tabular display of the widget data.
         * </p>
         * 
         * @param table
         *        The configuration for tabular display of the widget data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(TableDisplayConfigStruct table);

        /**
         * <p>
         * The configuration for tabular display of the widget data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableDisplayConfigStruct.Builder}
         * avoiding the need to create one manually via {@link TableDisplayConfigStruct#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableDisplayConfigStruct.Builder#build()} is called immediately
         * and its result is passed to {@link #table(TableDisplayConfigStruct)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link TableDisplayConfigStruct.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(TableDisplayConfigStruct)
         */
        default Builder table(Consumer<TableDisplayConfigStruct.Builder> table) {
            return table(TableDisplayConfigStruct.builder().applyMutation(table).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, GraphDisplayConfig> graph = DefaultSdkAutoConstructMap.getInstance();

        private TableDisplayConfigStruct table;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DisplayConfig model) {
            graph(model.graph);
            table(model.table);
        }

        public final Map<String, GraphDisplayConfig.Builder> getGraph() {
            Map<String, GraphDisplayConfig.Builder> result = GraphDisplayConfigMapCopier.copyToBuilder(this.graph);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setGraph(Map<String, GraphDisplayConfig.BuilderImpl> graph) {
            Object oldValue = this.graph;
            this.graph = GraphDisplayConfigMapCopier.copyFromBuilder(graph);
            handleUnionValueChange(Type.GRAPH, oldValue, this.graph);
        }

        @Override
        public final Builder graph(Map<String, GraphDisplayConfig> graph) {
            Object oldValue = this.graph;
            this.graph = GraphDisplayConfigMapCopier.copy(graph);
            handleUnionValueChange(Type.GRAPH, oldValue, this.graph);
            return this;
        }

        public final TableDisplayConfigStruct.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(TableDisplayConfigStruct.BuilderImpl table) {
            Object oldValue = this.table;
            this.table = table != null ? table.build() : null;
            handleUnionValueChange(Type.TABLE, oldValue, this.table);
        }

        @Override
        public final Builder table(TableDisplayConfigStruct table) {
            Object oldValue = this.table;
            this.table = table;
            handleUnionValueChange(Type.TABLE, oldValue, this.table);
            return this;
        }

        @Override
        public DisplayConfig build() {
            return new DisplayConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DisplayConfig#type()
     */
    public enum Type {
        GRAPH,

        TABLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
