/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.JobQueueDetail;
import software.amazon.awssdk.services.batch.model.JobQueueDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobQueuesResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeJobQueuesResponse> {
    private static final SdkField<List<JobQueueDetail>> JOB_QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobQueues").getter(DescribeJobQueuesResponse.getter(DescribeJobQueuesResponse::jobQueues)).setter(DescribeJobQueuesResponse.setter(Builder::jobQueues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobQueueDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeJobQueuesResponse.getter(DescribeJobQueuesResponse::nextToken)).setter(DescribeJobQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeJobQueuesResponse.memberNameToFieldInitializer();
    private final List<JobQueueDetail> jobQueues;
    private final String nextToken;

    private DescribeJobQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.jobQueues = builder.jobQueues;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobQueues() {
        return this.jobQueues != null && !(this.jobQueues instanceof SdkAutoConstructList);
    }

    public final List<JobQueueDetail> jobQueues() {
        return this.jobQueues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobQueues() ? this.jobQueues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesResponse)) {
            return false;
        }
        DescribeJobQueuesResponse other = (DescribeJobQueuesResponse)((Object)obj);
        return this.hasJobQueues() == other.hasJobQueues() && Objects.equals(this.jobQueues(), other.jobQueues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeJobQueuesResponse").add("JobQueues", this.hasJobQueues() ? this.jobQueues() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueues": {
                return Optional.ofNullable(clazz.cast(this.jobQueues()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobQueues", JOB_QUEUES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobQueuesResponse, T> g) {
        return obj -> g.apply((DescribeJobQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<JobQueueDetail> jobQueues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesResponse model) {
            super(model);
            this.jobQueues(model.jobQueues);
            this.nextToken(model.nextToken);
        }

        public final List<JobQueueDetail.Builder> getJobQueues() {
            List<JobQueueDetail.Builder> result = JobQueueDetailListCopier.copyToBuilder(this.jobQueues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobQueues(Collection<JobQueueDetail.BuilderImpl> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copyFromBuilder(jobQueues);
        }

        @Override
        public final Builder jobQueues(Collection<JobQueueDetail> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(JobQueueDetail ... jobQueues) {
            this.jobQueues(Arrays.asList(jobQueues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(Consumer<JobQueueDetail.Builder> ... jobQueues) {
            this.jobQueues(Stream.of(jobQueues).map(c -> (JobQueueDetail)((JobQueueDetail.Builder)JobQueueDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeJobQueuesResponse build() {
            return new DescribeJobQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobQueuesResponse> {
        public Builder jobQueues(Collection<JobQueueDetail> var1);

        public Builder jobQueues(JobQueueDetail ... var1);

        public Builder jobQueues(Consumer<JobQueueDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

