/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse;
import software.amazon.awssdk.services.batch.model.JobQueueDetail;

public class DescribeJobQueuesPublisher
implements SdkPublisher<DescribeJobQueuesResponse> {
    private final BatchAsyncClient client;
    private final DescribeJobQueuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeJobQueuesPublisher(BatchAsyncClient client, DescribeJobQueuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeJobQueuesPublisher(BatchAsyncClient client, DescribeJobQueuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeJobQueuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeJobQueuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobQueueDetail> jobQueues() {
        return this.flatMapIterable(response -> response.jobQueues());
    }

    private class DescribeJobQueuesResponseFetcher
    implements AsyncPageFetcher<DescribeJobQueuesResponse> {
        private DescribeJobQueuesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeJobQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeJobQueuesResponse> nextPage(DescribeJobQueuesResponse previousPage) {
            if (previousPage == null) {
                return DescribeJobQueuesPublisher.this.client.describeJobQueues(DescribeJobQueuesPublisher.this.firstRequest);
            }
            return DescribeJobQueuesPublisher.this.client.describeJobQueues((DescribeJobQueuesRequest)((Object)DescribeJobQueuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

