/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.LatestServiceJobAttempt;
import software.amazon.awssdk.services.batch.model.ServiceJobStatus;
import software.amazon.awssdk.services.batch.model.ServiceJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceJobSummary> {
    private static final SdkField<LatestServiceJobAttempt> LATEST_ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestAttempt").getter(ServiceJobSummary.getter(ServiceJobSummary::latestAttempt)).setter(ServiceJobSummary.setter(Builder::latestAttempt)).constructor(LatestServiceJobAttempt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAttempt").build()}).build();
    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdAt").getter(ServiceJobSummary.getter(ServiceJobSummary::createdAt)).setter(ServiceJobSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(ServiceJobSummary.getter(ServiceJobSummary::jobArn)).setter(ServiceJobSummary.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(ServiceJobSummary.getter(ServiceJobSummary::jobId)).setter(ServiceJobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(ServiceJobSummary.getter(ServiceJobSummary::jobName)).setter(ServiceJobSummary.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> SERVICE_JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceJobType").getter(ServiceJobSummary.getter(ServiceJobSummary::serviceJobTypeAsString)).setter(ServiceJobSummary.setter(Builder::serviceJobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceJobType").build()}).build();
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareIdentifier").getter(ServiceJobSummary.getter(ServiceJobSummary::shareIdentifier)).setter(ServiceJobSummary.setter(Builder::shareIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceJobSummary.getter(ServiceJobSummary::statusAsString)).setter(ServiceJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(ServiceJobSummary.getter(ServiceJobSummary::statusReason)).setter(ServiceJobSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(ServiceJobSummary.getter(ServiceJobSummary::startedAt)).setter(ServiceJobSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("stoppedAt").getter(ServiceJobSummary.getter(ServiceJobSummary::stoppedAt)).setter(ServiceJobSummary.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_ATTEMPT_FIELD, CREATED_AT_FIELD, JOB_ARN_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, SERVICE_JOB_TYPE_FIELD, SHARE_IDENTIFIER_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LatestServiceJobAttempt latestAttempt;
    private final Long createdAt;
    private final String jobArn;
    private final String jobId;
    private final String jobName;
    private final String serviceJobType;
    private final String shareIdentifier;
    private final String status;
    private final String statusReason;
    private final Long startedAt;
    private final Long stoppedAt;

    private ServiceJobSummary(BuilderImpl builder) {
        this.latestAttempt = builder.latestAttempt;
        this.createdAt = builder.createdAt;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.serviceJobType = builder.serviceJobType;
        this.shareIdentifier = builder.shareIdentifier;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
    }

    public final LatestServiceJobAttempt latestAttempt() {
        return this.latestAttempt;
    }

    public final Long createdAt() {
        return this.createdAt;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final ServiceJobType serviceJobType() {
        return ServiceJobType.fromValue(this.serviceJobType);
    }

    public final String serviceJobTypeAsString() {
        return this.serviceJobType;
    }

    public final String shareIdentifier() {
        return this.shareIdentifier;
    }

    public final ServiceJobStatus status() {
        return ServiceJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Long startedAt() {
        return this.startedAt;
    }

    public final Long stoppedAt() {
        return this.stoppedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceJobSummary)) {
            return false;
        }
        ServiceJobSummary other = (ServiceJobSummary)obj;
        return Objects.equals(this.latestAttempt(), other.latestAttempt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.serviceJobTypeAsString(), other.serviceJobTypeAsString()) && Objects.equals(this.shareIdentifier(), other.shareIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceJobSummary").add("LatestAttempt", (Object)this.latestAttempt()).add("CreatedAt", (Object)this.createdAt()).add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("ServiceJobType", (Object)this.serviceJobTypeAsString()).add("ShareIdentifier", (Object)this.shareIdentifier()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "latestAttempt": {
                return Optional.ofNullable(clazz.cast(this.latestAttempt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "serviceJobType": {
                return Optional.ofNullable(clazz.cast(this.serviceJobTypeAsString()));
            }
            case "shareIdentifier": {
                return Optional.ofNullable(clazz.cast(this.shareIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("latestAttempt", LATEST_ATTEMPT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("serviceJobType", SERVICE_JOB_TYPE_FIELD);
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceJobSummary, T> g) {
        return obj -> g.apply((ServiceJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LatestServiceJobAttempt latestAttempt;
        private Long createdAt;
        private String jobArn;
        private String jobId;
        private String jobName;
        private String serviceJobType;
        private String shareIdentifier;
        private String status;
        private String statusReason;
        private Long startedAt;
        private Long stoppedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceJobSummary model) {
            this.latestAttempt(model.latestAttempt);
            this.createdAt(model.createdAt);
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.serviceJobType(model.serviceJobType);
            this.shareIdentifier(model.shareIdentifier);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
        }

        public final LatestServiceJobAttempt.Builder getLatestAttempt() {
            return this.latestAttempt != null ? this.latestAttempt.toBuilder() : null;
        }

        public final void setLatestAttempt(LatestServiceJobAttempt.BuilderImpl latestAttempt) {
            this.latestAttempt = latestAttempt != null ? latestAttempt.build() : null;
        }

        @Override
        public final Builder latestAttempt(LatestServiceJobAttempt latestAttempt) {
            this.latestAttempt = latestAttempt;
            return this;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getServiceJobType() {
            return this.serviceJobType;
        }

        public final void setServiceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
        }

        @Override
        public final Builder serviceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
            return this;
        }

        @Override
        public final Builder serviceJobType(ServiceJobType serviceJobType) {
            this.serviceJobType(serviceJobType == null ? null : serviceJobType.toString());
            return this;
        }

        public final String getShareIdentifier() {
            return this.shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public ServiceJobSummary build() {
            return new ServiceJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceJobSummary> {
        public Builder latestAttempt(LatestServiceJobAttempt var1);

        default public Builder latestAttempt(Consumer<LatestServiceJobAttempt.Builder> latestAttempt) {
            return this.latestAttempt((LatestServiceJobAttempt)((LatestServiceJobAttempt.Builder)LatestServiceJobAttempt.builder().applyMutation(latestAttempt)).build());
        }

        public Builder createdAt(Long var1);

        public Builder jobArn(String var1);

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder serviceJobType(String var1);

        public Builder serviceJobType(ServiceJobType var1);

        public Builder shareIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(ServiceJobStatus var1);

        public Builder statusReason(String var1);

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);
    }
}

