/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ListServiceJobsRequest;
import software.amazon.awssdk.services.batch.model.ListServiceJobsResponse;
import software.amazon.awssdk.services.batch.model.ServiceJobSummary;

public class ListServiceJobsPublisher
implements SdkPublisher<ListServiceJobsResponse> {
    private final BatchAsyncClient client;
    private final ListServiceJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceJobsPublisher(BatchAsyncClient client, ListServiceJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceJobsPublisher(BatchAsyncClient client, ListServiceJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceJobSummary> jobSummaryList() {
        return this.flatMapIterable(response -> response.jobSummaryList());
    }

    private class ListServiceJobsResponseFetcher
    implements AsyncPageFetcher<ListServiceJobsResponse> {
        private ListServiceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceJobsResponse> nextPage(ListServiceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceJobsPublisher.this.client.listServiceJobs(ListServiceJobsPublisher.this.firstRequest);
            }
            return ListServiceJobsPublisher.this.client.listServiceJobs((ListServiceJobsRequest)((Object)ListServiceJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

