/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retry strategy for service jobs. This defines how many times to retry a failed service job and under what
 * conditions. For more information, see <a
 * href="https://docs.aws.amazon.com/batch/latest/userguide/service-job-retries.html">Service job retry strategies</a>
 * in the <i>Batch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceJobRetryStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceJobRetryStrategy.Builder, ServiceJobRetryStrategy> {
    private static final SdkField<Integer> ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("attempts").getter(getter(ServiceJobRetryStrategy::attempts)).setter(setter(Builder::attempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build()).build();

    private static final SdkField<List<ServiceJobEvaluateOnExit>> EVALUATE_ON_EXIT_FIELD = SdkField
            .<List<ServiceJobEvaluateOnExit>> builder(MarshallingType.LIST)
            .memberName("evaluateOnExit")
            .getter(getter(ServiceJobRetryStrategy::evaluateOnExit))
            .setter(setter(Builder::evaluateOnExit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluateOnExit").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceJobEvaluateOnExit> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceJobEvaluateOnExit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD,
            EVALUATE_ON_EXIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer attempts;

    private final List<ServiceJobEvaluateOnExit> evaluateOnExit;

    private ServiceJobRetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
        this.evaluateOnExit = builder.evaluateOnExit;
    }

    /**
     * <p>
     * The number of times to move a service job to <code>RUNNABLE</code> status. You can specify between 1 and 10
     * attempts.
     * </p>
     * 
     * @return The number of times to move a service job to <code>RUNNABLE</code> status. You can specify between 1 and
     *         10 attempts.
     */
    public final Integer attempts() {
        return attempts;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluateOnExit property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluateOnExit() {
        return evaluateOnExit != null && !(evaluateOnExit instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of <code>ServiceJobEvaluateOnExit</code> objects that specify conditions under which the service job should
     * be retried or failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluateOnExit} method.
     * </p>
     * 
     * @return Array of <code>ServiceJobEvaluateOnExit</code> objects that specify conditions under which the service
     *         job should be retried or failed.
     */
    public final List<ServiceJobEvaluateOnExit> evaluateOnExit() {
        return evaluateOnExit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attempts());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluateOnExit() ? evaluateOnExit() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceJobRetryStrategy)) {
            return false;
        }
        ServiceJobRetryStrategy other = (ServiceJobRetryStrategy) obj;
        return Objects.equals(attempts(), other.attempts()) && hasEvaluateOnExit() == other.hasEvaluateOnExit()
                && Objects.equals(evaluateOnExit(), other.evaluateOnExit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceJobRetryStrategy").add("Attempts", attempts())
                .add("EvaluateOnExit", hasEvaluateOnExit() ? evaluateOnExit() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attempts":
            return Optional.ofNullable(clazz.cast(attempts()));
        case "evaluateOnExit":
            return Optional.ofNullable(clazz.cast(evaluateOnExit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attempts", ATTEMPTS_FIELD);
        map.put("evaluateOnExit", EVALUATE_ON_EXIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceJobRetryStrategy, T> g) {
        return obj -> g.apply((ServiceJobRetryStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceJobRetryStrategy> {
        /**
         * <p>
         * The number of times to move a service job to <code>RUNNABLE</code> status. You can specify between 1 and 10
         * attempts.
         * </p>
         * 
         * @param attempts
         *        The number of times to move a service job to <code>RUNNABLE</code> status. You can specify between 1
         *        and 10 attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Integer attempts);

        /**
         * <p>
         * Array of <code>ServiceJobEvaluateOnExit</code> objects that specify conditions under which the service job
         * should be retried or failed.
         * </p>
         * 
         * @param evaluateOnExit
         *        Array of <code>ServiceJobEvaluateOnExit</code> objects that specify conditions under which the service
         *        job should be retried or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateOnExit(Collection<ServiceJobEvaluateOnExit> evaluateOnExit);

        /**
         * <p>
         * Array of <code>ServiceJobEvaluateOnExit</code> objects that specify conditions under which the service job
         * should be retried or failed.
         * </p>
         * 
         * @param evaluateOnExit
         *        Array of <code>ServiceJobEvaluateOnExit</code> objects that specify conditions under which the service
         *        job should be retried or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateOnExit(ServiceJobEvaluateOnExit... evaluateOnExit);

        /**
         * <p>
         * Array of <code>ServiceJobEvaluateOnExit</code> objects that specify conditions under which the service job
         * should be retried or failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.ServiceJobEvaluateOnExit.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.batch.model.ServiceJobEvaluateOnExit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.ServiceJobEvaluateOnExit.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluateOnExit(List<ServiceJobEvaluateOnExit>)}.
         * 
         * @param evaluateOnExit
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.ServiceJobEvaluateOnExit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluateOnExit(java.util.Collection<ServiceJobEvaluateOnExit>)
         */
        Builder evaluateOnExit(Consumer<ServiceJobEvaluateOnExit.Builder>... evaluateOnExit);
    }

    static final class BuilderImpl implements Builder {
        private Integer attempts;

        private List<ServiceJobEvaluateOnExit> evaluateOnExit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceJobRetryStrategy model) {
            attempts(model.attempts);
            evaluateOnExit(model.evaluateOnExit);
        }

        public final Integer getAttempts() {
            return attempts;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        @Override
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        public final List<ServiceJobEvaluateOnExit.Builder> getEvaluateOnExit() {
            List<ServiceJobEvaluateOnExit.Builder> result = ServiceJobEvaluateOnExitListCopier.copyToBuilder(this.evaluateOnExit);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluateOnExit(Collection<ServiceJobEvaluateOnExit.BuilderImpl> evaluateOnExit) {
            this.evaluateOnExit = ServiceJobEvaluateOnExitListCopier.copyFromBuilder(evaluateOnExit);
        }

        @Override
        public final Builder evaluateOnExit(Collection<ServiceJobEvaluateOnExit> evaluateOnExit) {
            this.evaluateOnExit = ServiceJobEvaluateOnExitListCopier.copy(evaluateOnExit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(ServiceJobEvaluateOnExit... evaluateOnExit) {
            evaluateOnExit(Arrays.asList(evaluateOnExit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(Consumer<ServiceJobEvaluateOnExit.Builder>... evaluateOnExit) {
            evaluateOnExit(Stream.of(evaluateOnExit).map(c -> ServiceJobEvaluateOnExit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceJobRetryStrategy build() {
            return new ServiceJobRetryStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
