/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConsumableResourcesResponse extends BatchResponse implements
        ToCopyableBuilder<ListConsumableResourcesResponse.Builder, ListConsumableResourcesResponse> {
    private static final SdkField<List<ConsumableResourceSummary>> CONSUMABLE_RESOURCES_FIELD = SdkField
            .<List<ConsumableResourceSummary>> builder(MarshallingType.LIST)
            .memberName("consumableResources")
            .getter(getter(ListConsumableResourcesResponse::consumableResources))
            .setter(setter(Builder::consumableResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConsumableResourceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConsumableResourceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConsumableResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConsumableResourceSummary> consumableResources;

    private final String nextToken;

    private ListConsumableResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.consumableResources = builder.consumableResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConsumableResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConsumableResources() {
        return consumableResources != null && !(consumableResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of consumable resources that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConsumableResources} method.
     * </p>
     * 
     * @return A list of consumable resources that match the request.
     */
    public final List<ConsumableResourceSummary> consumableResources() {
        return consumableResources;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListConsumableResources</code> request. When the
     * results of a <code>ListConsumableResources</code> request exceed <code>maxResults</code>, this value can be used
     * to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListConsumableResources</code> request.
     *         When the results of a <code>ListConsumableResources</code> request exceed <code>maxResults</code>, this
     *         value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumableResources() ? consumableResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConsumableResourcesResponse)) {
            return false;
        }
        ListConsumableResourcesResponse other = (ListConsumableResourcesResponse) obj;
        return hasConsumableResources() == other.hasConsumableResources()
                && Objects.equals(consumableResources(), other.consumableResources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConsumableResourcesResponse")
                .add("ConsumableResources", hasConsumableResources() ? consumableResources() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResources":
            return Optional.ofNullable(clazz.cast(consumableResources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResources", CONSUMABLE_RESOURCES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConsumableResourcesResponse, T> g) {
        return obj -> g.apply((ListConsumableResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConsumableResourcesResponse> {
        /**
         * <p>
         * A list of consumable resources that match the request.
         * </p>
         * 
         * @param consumableResources
         *        A list of consumable resources that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResources(Collection<ConsumableResourceSummary> consumableResources);

        /**
         * <p>
         * A list of consumable resources that match the request.
         * </p>
         * 
         * @param consumableResources
         *        A list of consumable resources that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResources(ConsumableResourceSummary... consumableResources);

        /**
         * <p>
         * A list of consumable resources that match the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.ConsumableResourceSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.batch.model.ConsumableResourceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.ConsumableResourceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #consumableResources(List<ConsumableResourceSummary>)}.
         * 
         * @param consumableResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.ConsumableResourceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumableResources(java.util.Collection<ConsumableResourceSummary>)
         */
        Builder consumableResources(Consumer<ConsumableResourceSummary.Builder>... consumableResources);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListConsumableResources</code> request. When
         * the results of a <code>ListConsumableResources</code> request exceed <code>maxResults</code>, this value can
         * be used to retrieve the next page of results. This value is <code>null</code> when there are no more results
         * to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListConsumableResources</code> request.
         *        When the results of a <code>ListConsumableResources</code> request exceed <code>maxResults</code>,
         *        this value can be used to retrieve the next page of results. This value is <code>null</code> when
         *        there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<ConsumableResourceSummary> consumableResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConsumableResourcesResponse model) {
            super(model);
            consumableResources(model.consumableResources);
            nextToken(model.nextToken);
        }

        public final List<ConsumableResourceSummary.Builder> getConsumableResources() {
            List<ConsumableResourceSummary.Builder> result = ConsumableResourceSummaryListCopier
                    .copyToBuilder(this.consumableResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumableResources(Collection<ConsumableResourceSummary.BuilderImpl> consumableResources) {
            this.consumableResources = ConsumableResourceSummaryListCopier.copyFromBuilder(consumableResources);
        }

        @Override
        public final Builder consumableResources(Collection<ConsumableResourceSummary> consumableResources) {
            this.consumableResources = ConsumableResourceSummaryListCopier.copy(consumableResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumableResources(ConsumableResourceSummary... consumableResources) {
            consumableResources(Arrays.asList(consumableResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumableResources(Consumer<ConsumableResourceSummary.Builder>... consumableResources) {
            consumableResources(Stream.of(consumableResources)
                    .map(c -> ConsumableResourceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConsumableResourcesResponse build() {
            return new ListConsumableResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
