/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Current information about a consumable resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsumableResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsumableResourceSummary.Builder, ConsumableResourceSummary> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResourceArn").getter(getter(ConsumableResourceSummary::consumableResourceArn))
            .setter(setter(Builder::consumableResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceArn").build())
            .build();

    private static final SdkField<String> CONSUMABLE_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResourceName").getter(getter(ConsumableResourceSummary::consumableResourceName))
            .setter(setter(Builder::consumableResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceName").build())
            .build();

    private static final SdkField<Long> TOTAL_QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalQuantity").getter(getter(ConsumableResourceSummary::totalQuantity))
            .setter(setter(Builder::totalQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalQuantity").build()).build();

    private static final SdkField<Long> IN_USE_QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("inUseQuantity").getter(getter(ConsumableResourceSummary::inUseQuantity))
            .setter(setter(Builder::inUseQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseQuantity").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ConsumableResourceSummary::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCE_ARN_FIELD,
            CONSUMABLE_RESOURCE_NAME_FIELD, TOTAL_QUANTITY_FIELD, IN_USE_QUANTITY_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String consumableResourceArn;

    private final String consumableResourceName;

    private final Long totalQuantity;

    private final Long inUseQuantity;

    private final String resourceType;

    private ConsumableResourceSummary(BuilderImpl builder) {
        this.consumableResourceArn = builder.consumableResourceArn;
        this.consumableResourceName = builder.consumableResourceName;
        this.totalQuantity = builder.totalQuantity;
        this.inUseQuantity = builder.inUseQuantity;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the consumable resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the consumable resource.
     */
    public final String consumableResourceArn() {
        return consumableResourceArn;
    }

    /**
     * <p>
     * The name of the consumable resource.
     * </p>
     * 
     * @return The name of the consumable resource.
     */
    public final String consumableResourceName() {
        return consumableResourceName;
    }

    /**
     * <p>
     * The total amount of the consumable resource that is available.
     * </p>
     * 
     * @return The total amount of the consumable resource that is available.
     */
    public final Long totalQuantity() {
        return totalQuantity;
    }

    /**
     * <p>
     * The amount of the consumable resource that is currently in use.
     * </p>
     * 
     * @return The amount of the consumable resource that is currently in use.
     */
    public final Long inUseQuantity() {
        return inUseQuantity;
    }

    /**
     * <p>
     * Indicates whether the resource is available to be re-used after a job completes. Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLENISHABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_REPLENISHABLE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the resource is available to be re-used after a job completes. Can be one of: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLENISHABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_REPLENISHABLE</code>
     *         </p>
     *         </li>
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(totalQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(inUseQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumableResourceSummary)) {
            return false;
        }
        ConsumableResourceSummary other = (ConsumableResourceSummary) obj;
        return Objects.equals(consumableResourceArn(), other.consumableResourceArn())
                && Objects.equals(consumableResourceName(), other.consumableResourceName())
                && Objects.equals(totalQuantity(), other.totalQuantity())
                && Objects.equals(inUseQuantity(), other.inUseQuantity()) && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsumableResourceSummary").add("ConsumableResourceArn", consumableResourceArn())
                .add("ConsumableResourceName", consumableResourceName()).add("TotalQuantity", totalQuantity())
                .add("InUseQuantity", inUseQuantity()).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResourceArn":
            return Optional.ofNullable(clazz.cast(consumableResourceArn()));
        case "consumableResourceName":
            return Optional.ofNullable(clazz.cast(consumableResourceName()));
        case "totalQuantity":
            return Optional.ofNullable(clazz.cast(totalQuantity()));
        case "inUseQuantity":
            return Optional.ofNullable(clazz.cast(inUseQuantity()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResourceArn", CONSUMABLE_RESOURCE_ARN_FIELD);
        map.put("consumableResourceName", CONSUMABLE_RESOURCE_NAME_FIELD);
        map.put("totalQuantity", TOTAL_QUANTITY_FIELD);
        map.put("inUseQuantity", IN_USE_QUANTITY_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsumableResourceSummary, T> g) {
        return obj -> g.apply((ConsumableResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsumableResourceSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the consumable resource.
         * </p>
         * 
         * @param consumableResourceArn
         *        The Amazon Resource Name (ARN) of the consumable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceArn(String consumableResourceArn);

        /**
         * <p>
         * The name of the consumable resource.
         * </p>
         * 
         * @param consumableResourceName
         *        The name of the consumable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceName(String consumableResourceName);

        /**
         * <p>
         * The total amount of the consumable resource that is available.
         * </p>
         * 
         * @param totalQuantity
         *        The total amount of the consumable resource that is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalQuantity(Long totalQuantity);

        /**
         * <p>
         * The amount of the consumable resource that is currently in use.
         * </p>
         * 
         * @param inUseQuantity
         *        The amount of the consumable resource that is currently in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseQuantity(Long inUseQuantity);

        /**
         * <p>
         * Indicates whether the resource is available to be re-used after a job completes. Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLENISHABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_REPLENISHABLE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        Indicates whether the resource is available to be re-used after a job completes. Can be one of: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLENISHABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_REPLENISHABLE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String consumableResourceArn;

        private String consumableResourceName;

        private Long totalQuantity;

        private Long inUseQuantity;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumableResourceSummary model) {
            consumableResourceArn(model.consumableResourceArn);
            consumableResourceName(model.consumableResourceName);
            totalQuantity(model.totalQuantity);
            inUseQuantity(model.inUseQuantity);
            resourceType(model.resourceType);
        }

        public final String getConsumableResourceArn() {
            return consumableResourceArn;
        }

        public final void setConsumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
        }

        @Override
        public final Builder consumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
            return this;
        }

        public final String getConsumableResourceName() {
            return consumableResourceName;
        }

        public final void setConsumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
        }

        @Override
        public final Builder consumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
            return this;
        }

        public final Long getTotalQuantity() {
            return totalQuantity;
        }

        public final void setTotalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
        }

        @Override
        public final Builder totalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        public final Long getInUseQuantity() {
            return inUseQuantity;
        }

        public final void setInUseQuantity(Long inUseQuantity) {
            this.inUseQuantity = inUseQuantity;
        }

        @Override
        public final Builder inUseQuantity(Long inUseQuantity) {
            this.inUseQuantity = inUseQuantity;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public ConsumableResourceSummary build() {
            return new ConsumableResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
