/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a job attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttemptDetail implements SdkPojo, Serializable, ToCopyableBuilder<AttemptDetail.Builder, AttemptDetail> {
    private static final SdkField<AttemptContainerDetail> CONTAINER_FIELD = SdkField
            .<AttemptContainerDetail> builder(MarshallingType.SDK_POJO).memberName("container")
            .getter(getter(AttemptDetail::container)).setter(setter(Builder::container))
            .constructor(AttemptContainerDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(AttemptDetail::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("stoppedAt")
            .getter(getter(AttemptDetail::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(AttemptDetail::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<List<AttemptEcsTaskDetails>> TASK_PROPERTIES_FIELD = SdkField
            .<List<AttemptEcsTaskDetails>> builder(MarshallingType.LIST)
            .memberName("taskProperties")
            .getter(getter(AttemptDetail::taskProperties))
            .setter(setter(Builder::taskProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttemptEcsTaskDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttemptEcsTaskDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FIELD,
            STARTED_AT_FIELD, STOPPED_AT_FIELD, STATUS_REASON_FIELD, TASK_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AttemptContainerDetail container;

    private final Long startedAt;

    private final Long stoppedAt;

    private final String statusReason;

    private final List<AttemptEcsTaskDetails> taskProperties;

    private AttemptDetail(BuilderImpl builder) {
        this.container = builder.container;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
        this.taskProperties = builder.taskProperties;
    }

    /**
     * <p>
     * The details for the container in this job attempt.
     * </p>
     * 
     * @return The details for the container in this job attempt.
     */
    public final AttemptContainerDetail container() {
        return container;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from the
     * <code>STARTING</code> state to the <code>RUNNING</code> state).
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from
     *         the <code>STARTING</code> state to the <code>RUNNING</code> state).
     */
    public final Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the attempt was stopped (when the attempt transitioned from the
     * <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the attempt was stopped (when the attempt transitioned from
     *         the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>
     *         ).
     */
    public final Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details for the current status of the job attempt.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details for the current status of the job attempt.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskProperties() {
        return taskProperties != null && !(taskProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties for a task definition that describes the container and volume definitions of an Amazon ECS task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskProperties} method.
     * </p>
     * 
     * @return The properties for a task definition that describes the container and volume definitions of an Amazon ECS
     *         task.
     */
    public final List<AttemptEcsTaskDetails> taskProperties() {
        return taskProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskProperties() ? taskProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptDetail)) {
            return false;
        }
        AttemptDetail other = (AttemptDetail) obj;
        return Objects.equals(container(), other.container()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(stoppedAt(), other.stoppedAt()) && Objects.equals(statusReason(), other.statusReason())
                && hasTaskProperties() == other.hasTaskProperties() && Objects.equals(taskProperties(), other.taskProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttemptDetail").add("Container", container()).add("StartedAt", startedAt())
                .add("StoppedAt", stoppedAt()).add("StatusReason", statusReason())
                .add("TaskProperties", hasTaskProperties() ? taskProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "container":
            return Optional.ofNullable(clazz.cast(container()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "taskProperties":
            return Optional.ofNullable(clazz.cast(taskProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("container", CONTAINER_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("taskProperties", TASK_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttemptDetail, T> g) {
        return obj -> g.apply((AttemptDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttemptDetail> {
        /**
         * <p>
         * The details for the container in this job attempt.
         * </p>
         * 
         * @param container
         *        The details for the container in this job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(AttemptContainerDetail container);

        /**
         * <p>
         * The details for the container in this job attempt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttemptContainerDetail.Builder} avoiding
         * the need to create one manually via {@link AttemptContainerDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttemptContainerDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #container(AttemptContainerDetail)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link AttemptContainerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(AttemptContainerDetail)
         */
        default Builder container(Consumer<AttemptContainerDetail.Builder> container) {
            return container(AttemptContainerDetail.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from the
         * <code>STARTING</code> state to the <code>RUNNING</code> state).
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned
         *        from the <code>STARTING</code> state to the <code>RUNNING</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the attempt was stopped (when the attempt transitioned from the
         * <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp (in milliseconds) for when the attempt was stopped (when the attempt transitioned
         *        from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
         *        <code>FAILED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * A short, human-readable string to provide additional details for the current status of the job attempt.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details for the current status of the job
         *        attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The properties for a task definition that describes the container and volume definitions of an Amazon ECS
         * task.
         * </p>
         * 
         * @param taskProperties
         *        The properties for a task definition that describes the container and volume definitions of an Amazon
         *        ECS task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProperties(Collection<AttemptEcsTaskDetails> taskProperties);

        /**
         * <p>
         * The properties for a task definition that describes the container and volume definitions of an Amazon ECS
         * task.
         * </p>
         * 
         * @param taskProperties
         *        The properties for a task definition that describes the container and volume definitions of an Amazon
         *        ECS task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProperties(AttemptEcsTaskDetails... taskProperties);

        /**
         * <p>
         * The properties for a task definition that describes the container and volume definitions of an Amazon ECS
         * task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.AttemptEcsTaskDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.batch.model.AttemptEcsTaskDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.AttemptEcsTaskDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #taskProperties(List<AttemptEcsTaskDetails>)}.
         * 
         * @param taskProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.AttemptEcsTaskDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskProperties(java.util.Collection<AttemptEcsTaskDetails>)
         */
        Builder taskProperties(Consumer<AttemptEcsTaskDetails.Builder>... taskProperties);
    }

    static final class BuilderImpl implements Builder {
        private AttemptContainerDetail container;

        private Long startedAt;

        private Long stoppedAt;

        private String statusReason;

        private List<AttemptEcsTaskDetails> taskProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptDetail model) {
            container(model.container);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
            statusReason(model.statusReason);
            taskProperties(model.taskProperties);
        }

        public final AttemptContainerDetail.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        public final void setContainer(AttemptContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(AttemptContainerDetail container) {
            this.container = container;
            return this;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final List<AttemptEcsTaskDetails.Builder> getTaskProperties() {
            List<AttemptEcsTaskDetails.Builder> result = ListAttemptEcsTaskDetailsCopier.copyToBuilder(this.taskProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskProperties(Collection<AttemptEcsTaskDetails.BuilderImpl> taskProperties) {
            this.taskProperties = ListAttemptEcsTaskDetailsCopier.copyFromBuilder(taskProperties);
        }

        @Override
        public final Builder taskProperties(Collection<AttemptEcsTaskDetails> taskProperties) {
            this.taskProperties = ListAttemptEcsTaskDetailsCopier.copy(taskProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(AttemptEcsTaskDetails... taskProperties) {
            taskProperties(Arrays.asList(taskProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(Consumer<AttemptEcsTaskDetails.Builder>... taskProperties) {
            taskProperties(Stream.of(taskProperties).map(c -> AttemptEcsTaskDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AttemptDetail build() {
            return new AttemptDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
