/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobQueueType {
    EKS("EKS"),
    ECS("ECS"),
    ECS_FARGATE("ECS_FARGATE"),
    SAGEMAKER_TRAINING("SAGEMAKER_TRAINING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobQueueType> VALUE_MAP;
    private final String value;

    private JobQueueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobQueueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobQueueType> knownValues() {
        EnumSet<JobQueueType> knownValues = EnumSet.allOf(JobQueueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobQueueType.class, JobQueueType::toString);
    }
}

