/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.CapacityLimit;
import software.amazon.awssdk.services.batch.model.CapacityLimitsCopier;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceEnvironmentRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, UpdateServiceEnvironmentRequest> {
    private static final SdkField<String> SERVICE_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceEnvironment").getter(UpdateServiceEnvironmentRequest.getter(UpdateServiceEnvironmentRequest::serviceEnvironment)).setter(UpdateServiceEnvironmentRequest.setter(Builder::serviceEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironment").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(UpdateServiceEnvironmentRequest.getter(UpdateServiceEnvironmentRequest::stateAsString)).setter(UpdateServiceEnvironmentRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<List<CapacityLimit>> CAPACITY_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityLimits").getter(UpdateServiceEnvironmentRequest.getter(UpdateServiceEnvironmentRequest::capacityLimits)).setter(UpdateServiceEnvironmentRequest.setter(Builder::capacityLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ENVIRONMENT_FIELD, STATE_FIELD, CAPACITY_LIMITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceEnvironmentRequest.memberNameToFieldInitializer();
    private final String serviceEnvironment;
    private final String state;
    private final List<CapacityLimit> capacityLimits;

    private UpdateServiceEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.serviceEnvironment = builder.serviceEnvironment;
        this.state = builder.state;
        this.capacityLimits = builder.capacityLimits;
    }

    public final String serviceEnvironment() {
        return this.serviceEnvironment;
    }

    public final ServiceEnvironmentState state() {
        return ServiceEnvironmentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasCapacityLimits() {
        return this.capacityLimits != null && !(this.capacityLimits instanceof SdkAutoConstructList);
    }

    public final List<CapacityLimit> capacityLimits() {
        return this.capacityLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityLimits() ? this.capacityLimits() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceEnvironmentRequest)) {
            return false;
        }
        UpdateServiceEnvironmentRequest other = (UpdateServiceEnvironmentRequest)((Object)obj);
        return Objects.equals(this.serviceEnvironment(), other.serviceEnvironment()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasCapacityLimits() == other.hasCapacityLimits() && Objects.equals(this.capacityLimits(), other.capacityLimits());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceEnvironmentRequest").add("ServiceEnvironment", (Object)this.serviceEnvironment()).add("State", (Object)this.stateAsString()).add("CapacityLimits", this.hasCapacityLimits() ? this.capacityLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceEnvironment": {
                return Optional.ofNullable(clazz.cast(this.serviceEnvironment()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "capacityLimits": {
                return Optional.ofNullable(clazz.cast(this.capacityLimits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceEnvironment", SERVICE_ENVIRONMENT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("capacityLimits", CAPACITY_LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateServiceEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String serviceEnvironment;
        private String state;
        private List<CapacityLimit> capacityLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceEnvironmentRequest model) {
            super(model);
            this.serviceEnvironment(model.serviceEnvironment);
            this.state(model.state);
            this.capacityLimits(model.capacityLimits);
        }

        public final String getServiceEnvironment() {
            return this.serviceEnvironment;
        }

        public final void setServiceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
        }

        @Override
        public final Builder serviceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ServiceEnvironmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<CapacityLimit.Builder> getCapacityLimits() {
            List<CapacityLimit.Builder> result = CapacityLimitsCopier.copyToBuilder(this.capacityLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityLimits(Collection<CapacityLimit.BuilderImpl> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copyFromBuilder(capacityLimits);
        }

        @Override
        public final Builder capacityLimits(Collection<CapacityLimit> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copy(capacityLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(CapacityLimit ... capacityLimits) {
            this.capacityLimits(Arrays.asList(capacityLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(Consumer<CapacityLimit.Builder> ... capacityLimits) {
            this.capacityLimits(Stream.of(capacityLimits).map(c -> (CapacityLimit)((CapacityLimit.Builder)CapacityLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceEnvironmentRequest build() {
            return new UpdateServiceEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceEnvironmentRequest> {
        public Builder serviceEnvironment(String var1);

        public Builder state(String var1);

        public Builder state(ServiceEnvironmentState var1);

        public Builder capacityLimits(Collection<CapacityLimit> var1);

        public Builder capacityLimits(CapacityLimit ... var1);

        public Builder capacityLimits(Consumer<CapacityLimit.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

