/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceEnvironmentState {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceEnvironmentState> VALUE_MAP;
    private final String value;

    private ServiceEnvironmentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceEnvironmentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceEnvironmentState> knownValues() {
        EnumSet<ServiceEnvironmentState> knownValues = EnumSet.allOf(ServiceEnvironmentState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceEnvironmentState.class, ServiceEnvironmentState::toString);
    }
}

