/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobDefinitionsResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeJobDefinitionsResponse.Builder, DescribeJobDefinitionsResponse> {
    private static final SdkField<List<JobDefinition>> JOB_DEFINITIONS_FIELD = SdkField
            .<List<JobDefinition>> builder(MarshallingType.LIST)
            .memberName("jobDefinitions")
            .getter(getter(DescribeJobDefinitionsResponse::jobDefinitions))
            .setter(setter(Builder::jobDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeJobDefinitionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<JobDefinition> jobDefinitions;

    private final String nextToken;

    private DescribeJobDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitions = builder.jobDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobDefinitions() {
        return jobDefinitions != null && !(jobDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of job definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobDefinitions} method.
     * </p>
     * 
     * @return The list of job definitions.
     */
    public final List<JobDefinition> jobDefinitions() {
        return jobDefinitions;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the
     * results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be used
     * to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When
     *         the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value
     *         can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobDefinitions() ? jobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsResponse)) {
            return false;
        }
        DescribeJobDefinitionsResponse other = (DescribeJobDefinitionsResponse) obj;
        return hasJobDefinitions() == other.hasJobDefinitions() && Objects.equals(jobDefinitions(), other.jobDefinitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobDefinitionsResponse")
                .add("JobDefinitions", hasJobDefinitions() ? jobDefinitions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitions":
            return Optional.ofNullable(clazz.cast(jobDefinitions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobDefinitions", JOB_DEFINITIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeJobDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
        /**
         * <p>
         * The list of job definitions.
         * </p>
         * 
         * @param jobDefinitions
         *        The list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(Collection<JobDefinition> jobDefinitions);

        /**
         * <p>
         * The list of job definitions.
         * </p>
         * 
         * @param jobDefinitions
         *        The list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(JobDefinition... jobDefinitions);

        /**
         * <p>
         * The list of job definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.JobDefinition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.JobDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.JobDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #jobDefinitions(List<JobDefinition>)}.
         * 
         * @param jobDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.JobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDefinitions(java.util.Collection<JobDefinition>)
         */
        Builder jobDefinitions(Consumer<JobDefinition.Builder>... jobDefinitions);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the
         * results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be
         * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request.
         *        When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this
         *        value can be used to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<JobDefinition> jobDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsResponse model) {
            super(model);
            jobDefinitions(model.jobDefinitions);
            nextToken(model.nextToken);
        }

        public final List<JobDefinition.Builder> getJobDefinitions() {
            List<JobDefinition.Builder> result = JobDefinitionListCopier.copyToBuilder(this.jobDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobDefinitions(Collection<JobDefinition.BuilderImpl> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copyFromBuilder(jobDefinitions);
        }

        @Override
        public final Builder jobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(JobDefinition... jobDefinitions) {
            jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(Consumer<JobDefinition.Builder>... jobDefinitions) {
            jobDefinitions(Stream.of(jobDefinitions).map(c -> JobDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeJobDefinitionsResponse build() {
            return new DescribeJobDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
