/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.UserdataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateSpecificationOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateSpecificationOverride> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchTemplateId").getter(LaunchTemplateSpecificationOverride.getter(LaunchTemplateSpecificationOverride::launchTemplateId)).setter(LaunchTemplateSpecificationOverride.setter(Builder::launchTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateId").build()}).build();
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchTemplateName").getter(LaunchTemplateSpecificationOverride.getter(LaunchTemplateSpecificationOverride::launchTemplateName)).setter(LaunchTemplateSpecificationOverride.setter(Builder::launchTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateName").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(LaunchTemplateSpecificationOverride.getter(LaunchTemplateSpecificationOverride::version)).setter(LaunchTemplateSpecificationOverride.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<String>> TARGET_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetInstanceTypes").getter(LaunchTemplateSpecificationOverride.getter(LaunchTemplateSpecificationOverride::targetInstanceTypes)).setter(LaunchTemplateSpecificationOverride.setter(Builder::targetInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USERDATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userdataType").getter(LaunchTemplateSpecificationOverride.getter(LaunchTemplateSpecificationOverride::userdataTypeAsString)).setter(LaunchTemplateSpecificationOverride.setter(Builder::userdataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userdataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_TEMPLATE_NAME_FIELD, VERSION_FIELD, TARGET_INSTANCE_TYPES_FIELD, USERDATA_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplateSpecificationOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final String version;
    private final List<String> targetInstanceTypes;
    private final String userdataType;

    private LaunchTemplateSpecificationOverride(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.version = builder.version;
        this.targetInstanceTypes = builder.targetInstanceTypes;
        this.userdataType = builder.userdataType;
    }

    public final String launchTemplateId() {
        return this.launchTemplateId;
    }

    public final String launchTemplateName() {
        return this.launchTemplateName;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasTargetInstanceTypes() {
        return this.targetInstanceTypes != null && !(this.targetInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> targetInstanceTypes() {
        return this.targetInstanceTypes;
    }

    public final UserdataType userdataType() {
        return UserdataType.fromValue(this.userdataType);
    }

    public final String userdataTypeAsString() {
        return this.userdataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetInstanceTypes() ? this.targetInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userdataTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateSpecificationOverride)) {
            return false;
        }
        LaunchTemplateSpecificationOverride other = (LaunchTemplateSpecificationOverride)obj;
        return Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.version(), other.version()) && this.hasTargetInstanceTypes() == other.hasTargetInstanceTypes() && Objects.equals(this.targetInstanceTypes(), other.targetInstanceTypes()) && Objects.equals(this.userdataTypeAsString(), other.userdataTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateSpecificationOverride").add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("Version", (Object)this.version()).add("TargetInstanceTypes", this.hasTargetInstanceTypes() ? this.targetInstanceTypes() : null).add("UserdataType", (Object)this.userdataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "launchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "targetInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceTypes()));
            }
            case "userdataType": {
                return Optional.ofNullable(clazz.cast(this.userdataTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("launchTemplateId", LAUNCH_TEMPLATE_ID_FIELD);
        map.put("launchTemplateName", LAUNCH_TEMPLATE_NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("targetInstanceTypes", TARGET_INSTANCE_TYPES_FIELD);
        map.put("userdataType", USERDATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateSpecificationOverride, T> g) {
        return obj -> g.apply((LaunchTemplateSpecificationOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchTemplateId;
        private String launchTemplateName;
        private String version;
        private List<String> targetInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String userdataType;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateSpecificationOverride model) {
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.version(model.version);
            this.targetInstanceTypes(model.targetInstanceTypes);
            this.userdataType(model.userdataType);
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getTargetInstanceTypes() {
            if (this.targetInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetInstanceTypes;
        }

        public final void setTargetInstanceTypes(Collection<String> targetInstanceTypes) {
            this.targetInstanceTypes = StringListCopier.copy(targetInstanceTypes);
        }

        @Override
        public final Builder targetInstanceTypes(Collection<String> targetInstanceTypes) {
            this.targetInstanceTypes = StringListCopier.copy(targetInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetInstanceTypes(String ... targetInstanceTypes) {
            this.targetInstanceTypes(Arrays.asList(targetInstanceTypes));
            return this;
        }

        public final String getUserdataType() {
            return this.userdataType;
        }

        public final void setUserdataType(String userdataType) {
            this.userdataType = userdataType;
        }

        @Override
        public final Builder userdataType(String userdataType) {
            this.userdataType = userdataType;
            return this;
        }

        @Override
        public final Builder userdataType(UserdataType userdataType) {
            this.userdataType(userdataType == null ? null : userdataType.toString());
            return this;
        }

        public LaunchTemplateSpecificationOverride build() {
            return new LaunchTemplateSpecificationOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateSpecificationOverride> {
        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder version(String var1);

        public Builder targetInstanceTypes(Collection<String> var1);

        public Builder targetInstanceTypes(String ... var1);

        public Builder userdataType(String var1);

        public Builder userdataType(UserdataType var1);
    }
}

