/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a list of the first 100 <code>RUNNABLE</code> jobs associated to a single job queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrontOfQueueDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<FrontOfQueueDetail.Builder, FrontOfQueueDetail> {
    private static final SdkField<List<FrontOfQueueJobSummary>> JOBS_FIELD = SdkField
            .<List<FrontOfQueueJobSummary>> builder(MarshallingType.LIST)
            .memberName("jobs")
            .getter(getter(FrontOfQueueDetail::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FrontOfQueueJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FrontOfQueueJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LAST_UPDATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastUpdatedAt").getter(getter(FrontOfQueueDetail::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD,
            LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FrontOfQueueJobSummary> jobs;

    private final Long lastUpdatedAt;

    private FrontOfQueueDetail(BuilderImpl builder) {
        this.jobs = builder.jobs;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Jobs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the first 100 <code>RUNNABLE</code> jobs in a named job queue. For
     * first-in-first-out (FIFO) job queues, jobs are ordered based on their submission time. For fair-share scheduling
     * (FSS) job queues, jobs are ordered based on their job priority and share usage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobs} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the first 100 <code>RUNNABLE</code> jobs in a named job queue. For
     *         first-in-first-out (FIFO) job queues, jobs are ordered based on their submission time. For fair-share
     *         scheduling (FSS) job queues, jobs are ordered based on their job priority and share usage.
     */
    public final List<FrontOfQueueJobSummary> jobs() {
        return jobs;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when each of the first 100 <code>RUNNABLE</code> jobs were last updated.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when each of the first 100 <code>RUNNABLE</code> jobs were last
     *         updated.
     */
    public final Long lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasJobs() ? jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrontOfQueueDetail)) {
            return false;
        }
        FrontOfQueueDetail other = (FrontOfQueueDetail) obj;
        return hasJobs() == other.hasJobs() && Objects.equals(jobs(), other.jobs())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrontOfQueueDetail").add("Jobs", hasJobs() ? jobs() : null)
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobs", JOBS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FrontOfQueueDetail, T> g) {
        return obj -> g.apply((FrontOfQueueDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrontOfQueueDetail> {
        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the first 100 <code>RUNNABLE</code> jobs in a named job queue. For
         * first-in-first-out (FIFO) job queues, jobs are ordered based on their submission time. For fair-share
         * scheduling (FSS) job queues, jobs are ordered based on their job priority and share usage.
         * </p>
         * 
         * @param jobs
         *        The Amazon Resource Names (ARNs) of the first 100 <code>RUNNABLE</code> jobs in a named job queue. For
         *        first-in-first-out (FIFO) job queues, jobs are ordered based on their submission time. For fair-share
         *        scheduling (FSS) job queues, jobs are ordered based on their job priority and share usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<FrontOfQueueJobSummary> jobs);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the first 100 <code>RUNNABLE</code> jobs in a named job queue. For
         * first-in-first-out (FIFO) job queues, jobs are ordered based on their submission time. For fair-share
         * scheduling (FSS) job queues, jobs are ordered based on their job priority and share usage.
         * </p>
         * 
         * @param jobs
         *        The Amazon Resource Names (ARNs) of the first 100 <code>RUNNABLE</code> jobs in a named job queue. For
         *        first-in-first-out (FIFO) job queues, jobs are ordered based on their submission time. For fair-share
         *        scheduling (FSS) job queues, jobs are ordered based on their job priority and share usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(FrontOfQueueJobSummary... jobs);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the first 100 <code>RUNNABLE</code> jobs in a named job queue. For
         * first-in-first-out (FIFO) job queues, jobs are ordered based on their submission time. For fair-share
         * scheduling (FSS) job queues, jobs are ordered based on their job priority and share usage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.FrontOfQueueJobSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.batch.model.FrontOfQueueJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.FrontOfQueueJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #jobs(List<FrontOfQueueJobSummary>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.FrontOfQueueJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(java.util.Collection<FrontOfQueueJobSummary>)
         */
        Builder jobs(Consumer<FrontOfQueueJobSummary.Builder>... jobs);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when each of the first 100 <code>RUNNABLE</code> jobs were last
         * updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The Unix timestamp (in milliseconds) for when each of the first 100 <code>RUNNABLE</code> jobs were
         *        last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Long lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private List<FrontOfQueueJobSummary> jobs = DefaultSdkAutoConstructList.getInstance();

        private Long lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FrontOfQueueDetail model) {
            jobs(model.jobs);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final List<FrontOfQueueJobSummary.Builder> getJobs() {
            List<FrontOfQueueJobSummary.Builder> result = FrontOfQueueJobSummaryListCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobs(Collection<FrontOfQueueJobSummary.BuilderImpl> jobs) {
            this.jobs = FrontOfQueueJobSummaryListCopier.copyFromBuilder(jobs);
        }

        @Override
        public final Builder jobs(Collection<FrontOfQueueJobSummary> jobs) {
            this.jobs = FrontOfQueueJobSummaryListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(FrontOfQueueJobSummary... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<FrontOfQueueJobSummary.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> FrontOfQueueJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public FrontOfQueueDetail build() {
            return new FrontOfQueueDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
