/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>persistentVolumeClaim</code> volume is used to mount a <a
 * href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/">PersistentVolume</a> into a Pod.
 * PersistentVolumeClaims are a way for users to "claim" durable storage without knowing the details of the particular
 * cloud environment. See the information about <a
 * href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/">PersistentVolumes</a> in the <i>Kubernetes
 * documentation</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksPersistentVolumeClaim implements SdkPojo, Serializable,
        ToCopyableBuilder<EksPersistentVolumeClaim.Builder, EksPersistentVolumeClaim> {
    private static final SdkField<String> CLAIM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("claimName").getter(getter(EksPersistentVolumeClaim::claimName)).setter(setter(Builder::claimName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimName").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readOnly").getter(getter(EksPersistentVolumeClaim::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAIM_NAME_FIELD,
            READ_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String claimName;

    private final Boolean readOnly;

    private EksPersistentVolumeClaim(BuilderImpl builder) {
        this.claimName = builder.claimName;
        this.readOnly = builder.readOnly;
    }

    /**
     * <p>
     * The name of the <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code>. For more
     * information, see <a
     * href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims"> Persistent Volume
     * Claims</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return The name of the <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code>. For more
     *         information, see <a
     *         href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims"> Persistent
     *         Volume Claims</a> in the <i>Kubernetes documentation</i>.
     */
    public final String claimName() {
        return claimName;
    }

    /**
     * <p>
     * An optional boolean value indicating if the mount is read only. Default is false. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts"> Read Only Mounts</a> in the
     * <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return An optional boolean value indicating if the mount is read only. Default is false. For more information,
     *         see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts"> Read Only Mounts</a>
     *         in the <i>Kubernetes documentation</i>.
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(claimName());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPersistentVolumeClaim)) {
            return false;
        }
        EksPersistentVolumeClaim other = (EksPersistentVolumeClaim) obj;
        return Objects.equals(claimName(), other.claimName()) && Objects.equals(readOnly(), other.readOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksPersistentVolumeClaim").add("ClaimName", claimName()).add("ReadOnly", readOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "claimName":
            return Optional.ofNullable(clazz.cast(claimName()));
        case "readOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("claimName", CLAIM_NAME_FIELD);
        map.put("readOnly", READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksPersistentVolumeClaim, T> g) {
        return obj -> g.apply((EksPersistentVolumeClaim) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksPersistentVolumeClaim> {
        /**
         * <p>
         * The name of the <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code>. For more
         * information, see <a
         * href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims"> Persistent
         * Volume Claims</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param claimName
         *        The name of the <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code>. For
         *        more information, see <a
         *        href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims">
         *        Persistent Volume Claims</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimName(String claimName);

        /**
         * <p>
         * An optional boolean value indicating if the mount is read only. Default is false. For more information, see
         * <a href="https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts"> Read Only Mounts</a> in the
         * <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param readOnly
         *        An optional boolean value indicating if the mount is read only. Default is false. For more
         *        information, see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts"> Read
         *        Only Mounts</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);
    }

    static final class BuilderImpl implements Builder {
        private String claimName;

        private Boolean readOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(EksPersistentVolumeClaim model) {
            claimName(model.claimName);
            readOnly(model.readOnly);
        }

        public final String getClaimName() {
            return claimName;
        }

        public final void setClaimName(String claimName) {
            this.claimName = claimName;
        }

        @Override
        public final Builder claimName(String claimName) {
            this.claimName = claimName;
            return this;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        public EksPersistentVolumeClaim build() {
            return new EksPersistentVolumeClaim(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
