/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an attempt to run a service job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceJobAttemptDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceJobAttemptDetail.Builder, ServiceJobAttemptDetail> {
    private static final SdkField<ServiceResourceId> SERVICE_RESOURCE_ID_FIELD = SdkField
            .<ServiceResourceId> builder(MarshallingType.SDK_POJO).memberName("serviceResourceId")
            .getter(getter(ServiceJobAttemptDetail::serviceResourceId)).setter(setter(Builder::serviceResourceId))
            .constructor(ServiceResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceResourceId").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(ServiceJobAttemptDetail::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("stoppedAt")
            .getter(getter(ServiceJobAttemptDetail::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(ServiceJobAttemptDetail::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_RESOURCE_ID_FIELD,
            STARTED_AT_FIELD, STOPPED_AT_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceResourceId serviceResourceId;

    private final Long startedAt;

    private final Long stoppedAt;

    private final String statusReason;

    private ServiceJobAttemptDetail(BuilderImpl builder) {
        this.serviceResourceId = builder.serviceResourceId;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The service resource identifier associated with the service job attempt.
     * </p>
     * 
     * @return The service resource identifier associated with the service job attempt.
     */
    public final ServiceResourceId serviceResourceId() {
        return serviceResourceId;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job attempt was started.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job attempt was started.
     */
    public final Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job attempt stopped running.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job attempt stopped running.
     */
    public final Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * A string that provides additional details for the current status of the service job attempt.
     * </p>
     * 
     * @return A string that provides additional details for the current status of the service job attempt.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceJobAttemptDetail)) {
            return false;
        }
        ServiceJobAttemptDetail other = (ServiceJobAttemptDetail) obj;
        return Objects.equals(serviceResourceId(), other.serviceResourceId()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(stoppedAt(), other.stoppedAt()) && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceJobAttemptDetail").add("ServiceResourceId", serviceResourceId())
                .add("StartedAt", startedAt()).add("StoppedAt", stoppedAt()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceResourceId":
            return Optional.ofNullable(clazz.cast(serviceResourceId()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceResourceId", SERVICE_RESOURCE_ID_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceJobAttemptDetail, T> g) {
        return obj -> g.apply((ServiceJobAttemptDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceJobAttemptDetail> {
        /**
         * <p>
         * The service resource identifier associated with the service job attempt.
         * </p>
         * 
         * @param serviceResourceId
         *        The service resource identifier associated with the service job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceResourceId(ServiceResourceId serviceResourceId);

        /**
         * <p>
         * The service resource identifier associated with the service job attempt.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceResourceId.Builder} avoiding the
         * need to create one manually via {@link ServiceResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceResourceId(ServiceResourceId)}.
         * 
         * @param serviceResourceId
         *        a consumer that will call methods on {@link ServiceResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceResourceId(ServiceResourceId)
         */
        default Builder serviceResourceId(Consumer<ServiceResourceId.Builder> serviceResourceId) {
            return serviceResourceId(ServiceResourceId.builder().applyMutation(serviceResourceId).build());
        }

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job attempt was started.
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp (in milliseconds) for when the service job attempt was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job attempt stopped running.
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp (in milliseconds) for when the service job attempt stopped running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * A string that provides additional details for the current status of the service job attempt.
         * </p>
         * 
         * @param statusReason
         *        A string that provides additional details for the current status of the service job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private ServiceResourceId serviceResourceId;

        private Long startedAt;

        private Long stoppedAt;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceJobAttemptDetail model) {
            serviceResourceId(model.serviceResourceId);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
            statusReason(model.statusReason);
        }

        public final ServiceResourceId.Builder getServiceResourceId() {
            return serviceResourceId != null ? serviceResourceId.toBuilder() : null;
        }

        public final void setServiceResourceId(ServiceResourceId.BuilderImpl serviceResourceId) {
            this.serviceResourceId = serviceResourceId != null ? serviceResourceId.build() : null;
        }

        @Override
        public final Builder serviceResourceId(ServiceResourceId serviceResourceId) {
            this.serviceResourceId = serviceResourceId;
            return this;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public ServiceJobAttemptDetail build() {
            return new ServiceJobAttemptDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
