/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse;
import software.amazon.awssdk.services.batch.model.JobQueueDetail;

public class DescribeJobQueuesIterable
implements SdkIterable<DescribeJobQueuesResponse> {
    private final BatchClient client;
    private final DescribeJobQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeJobQueuesIterable(BatchClient client, DescribeJobQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeJobQueuesResponseFetcher();
    }

    public Iterator<DescribeJobQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobQueueDetail> jobQueues() {
        Function<DescribeJobQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobQueues() != null) {
                return response.jobQueues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeJobQueuesResponseFetcher
    implements SyncPageFetcher<DescribeJobQueuesResponse> {
        private DescribeJobQueuesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeJobQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeJobQueuesResponse nextPage(DescribeJobQueuesResponse previousPage) {
            if (previousPage == null) {
                return DescribeJobQueuesIterable.this.client.describeJobQueues(DescribeJobQueuesIterable.this.firstRequest);
            }
            return DescribeJobQueuesIterable.this.client.describeJobQueues((DescribeJobQueuesRequest)((Object)DescribeJobQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

