/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse;

public class DescribeComputeEnvironmentsPublisher
implements SdkPublisher<DescribeComputeEnvironmentsResponse> {
    private final BatchAsyncClient client;
    private final DescribeComputeEnvironmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeComputeEnvironmentsPublisher(BatchAsyncClient client, DescribeComputeEnvironmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeComputeEnvironmentsPublisher(BatchAsyncClient client, DescribeComputeEnvironmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeComputeEnvironmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeComputeEnvironmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComputeEnvironmentDetail> computeEnvironments() {
        Function<DescribeComputeEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeEnvironments() != null) {
                return response.computeEnvironments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeComputeEnvironmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeComputeEnvironmentsResponseFetcher
    implements AsyncPageFetcher<DescribeComputeEnvironmentsResponse> {
        private DescribeComputeEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeComputeEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeComputeEnvironmentsResponse> nextPage(DescribeComputeEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeComputeEnvironmentsPublisher.this.client.describeComputeEnvironments(DescribeComputeEnvironmentsPublisher.this.firstRequest);
            }
            return DescribeComputeEnvironmentsPublisher.this.client.describeComputeEnvironments((DescribeComputeEnvironmentsRequest)((Object)DescribeComputeEnvironmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

