/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.SchedulingPolicyListingDetail;
import software.amazon.awssdk.services.batch.model.SchedulingPolicyListingDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchedulingPoliciesResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, ListSchedulingPoliciesResponse> {
    private static final SdkField<List<SchedulingPolicyListingDetail>> SCHEDULING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schedulingPolicies").getter(ListSchedulingPoliciesResponse.getter(ListSchedulingPoliciesResponse::schedulingPolicies)).setter(ListSchedulingPoliciesResponse.setter(Builder::schedulingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchedulingPolicyListingDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSchedulingPoliciesResponse.getter(ListSchedulingPoliciesResponse::nextToken)).setter(ListSchedulingPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULING_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSchedulingPoliciesResponse.memberNameToFieldInitializer();
    private final List<SchedulingPolicyListingDetail> schedulingPolicies;
    private final String nextToken;

    private ListSchedulingPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.schedulingPolicies = builder.schedulingPolicies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSchedulingPolicies() {
        return this.schedulingPolicies != null && !(this.schedulingPolicies instanceof SdkAutoConstructList);
    }

    public final List<SchedulingPolicyListingDetail> schedulingPolicies() {
        return this.schedulingPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchedulingPolicies() ? this.schedulingPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchedulingPoliciesResponse)) {
            return false;
        }
        ListSchedulingPoliciesResponse other = (ListSchedulingPoliciesResponse)((Object)obj);
        return this.hasSchedulingPolicies() == other.hasSchedulingPolicies() && Objects.equals(this.schedulingPolicies(), other.schedulingPolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchedulingPoliciesResponse").add("SchedulingPolicies", this.hasSchedulingPolicies() ? this.schedulingPolicies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schedulingPolicies": {
                return Optional.ofNullable(clazz.cast(this.schedulingPolicies()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schedulingPolicies", SCHEDULING_POLICIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchedulingPoliciesResponse, T> g) {
        return obj -> g.apply((ListSchedulingPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<SchedulingPolicyListingDetail> schedulingPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchedulingPoliciesResponse model) {
            super(model);
            this.schedulingPolicies(model.schedulingPolicies);
            this.nextToken(model.nextToken);
        }

        public final List<SchedulingPolicyListingDetail.Builder> getSchedulingPolicies() {
            List<SchedulingPolicyListingDetail.Builder> result = SchedulingPolicyListingDetailListCopier.copyToBuilder(this.schedulingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchedulingPolicies(Collection<SchedulingPolicyListingDetail.BuilderImpl> schedulingPolicies) {
            this.schedulingPolicies = SchedulingPolicyListingDetailListCopier.copyFromBuilder(schedulingPolicies);
        }

        @Override
        public final Builder schedulingPolicies(Collection<SchedulingPolicyListingDetail> schedulingPolicies) {
            this.schedulingPolicies = SchedulingPolicyListingDetailListCopier.copy(schedulingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedulingPolicies(SchedulingPolicyListingDetail ... schedulingPolicies) {
            this.schedulingPolicies(Arrays.asList(schedulingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedulingPolicies(Consumer<SchedulingPolicyListingDetail.Builder> ... schedulingPolicies) {
            this.schedulingPolicies(Stream.of(schedulingPolicies).map(c -> (SchedulingPolicyListingDetail)((SchedulingPolicyListingDetail.Builder)SchedulingPolicyListingDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSchedulingPoliciesResponse build() {
            return new ListSchedulingPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchedulingPoliciesResponse> {
        public Builder schedulingPolicies(Collection<SchedulingPolicyListingDetail> var1);

        public Builder schedulingPolicies(SchedulingPolicyListingDetail ... var1);

        public Builder schedulingPolicies(Consumer<SchedulingPolicyListingDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

