/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceRequest;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceResponse;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceSummary;

public class ListJobsByConsumableResourcePublisher
implements SdkPublisher<ListJobsByConsumableResourceResponse> {
    private final BatchAsyncClient client;
    private final ListJobsByConsumableResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobsByConsumableResourcePublisher(BatchAsyncClient client, ListJobsByConsumableResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobsByConsumableResourcePublisher(BatchAsyncClient client, ListJobsByConsumableResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobsByConsumableResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobsByConsumableResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListJobsByConsumableResourceSummary> jobs() {
        Function<ListJobsByConsumableResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobsByConsumableResourceResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobsByConsumableResourceResponseFetcher
    implements AsyncPageFetcher<ListJobsByConsumableResourceResponse> {
        private ListJobsByConsumableResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsByConsumableResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobsByConsumableResourceResponse> nextPage(ListJobsByConsumableResourceResponse previousPage) {
            if (previousPage == null) {
                return ListJobsByConsumableResourcePublisher.this.client.listJobsByConsumableResource(ListJobsByConsumableResourcePublisher.this.firstRequest);
            }
            return ListJobsByConsumableResourcePublisher.this.client.listJobsByConsumableResource((ListJobsByConsumableResourceRequest)((Object)ListJobsByConsumableResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

