/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConsumableResourceResponse extends BatchResponse implements
        ToCopyableBuilder<UpdateConsumableResourceResponse.Builder, UpdateConsumableResourceResponse> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResourceName").getter(getter(UpdateConsumableResourceResponse::consumableResourceName))
            .setter(setter(Builder::consumableResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceName").build())
            .build();

    private static final SdkField<String> CONSUMABLE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResourceArn").getter(getter(UpdateConsumableResourceResponse::consumableResourceArn))
            .setter(setter(Builder::consumableResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceArn").build())
            .build();

    private static final SdkField<Long> TOTAL_QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalQuantity").getter(getter(UpdateConsumableResourceResponse::totalQuantity))
            .setter(setter(Builder::totalQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalQuantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSUMABLE_RESOURCE_NAME_FIELD, CONSUMABLE_RESOURCE_ARN_FIELD, TOTAL_QUANTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String consumableResourceName;

    private final String consumableResourceArn;

    private final Long totalQuantity;

    private UpdateConsumableResourceResponse(BuilderImpl builder) {
        super(builder);
        this.consumableResourceName = builder.consumableResourceName;
        this.consumableResourceArn = builder.consumableResourceArn;
        this.totalQuantity = builder.totalQuantity;
    }

    /**
     * <p>
     * The name of the consumable resource to be updated.
     * </p>
     * 
     * @return The name of the consumable resource to be updated.
     */
    public final String consumableResourceName() {
        return consumableResourceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the consumable resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the consumable resource.
     */
    public final String consumableResourceArn() {
        return consumableResourceArn;
    }

    /**
     * <p>
     * The total amount of the consumable resource that is available.
     * </p>
     * 
     * @return The total amount of the consumable resource that is available.
     */
    public final Long totalQuantity() {
        return totalQuantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(totalQuantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConsumableResourceResponse)) {
            return false;
        }
        UpdateConsumableResourceResponse other = (UpdateConsumableResourceResponse) obj;
        return Objects.equals(consumableResourceName(), other.consumableResourceName())
                && Objects.equals(consumableResourceArn(), other.consumableResourceArn())
                && Objects.equals(totalQuantity(), other.totalQuantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConsumableResourceResponse").add("ConsumableResourceName", consumableResourceName())
                .add("ConsumableResourceArn", consumableResourceArn()).add("TotalQuantity", totalQuantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResourceName":
            return Optional.ofNullable(clazz.cast(consumableResourceName()));
        case "consumableResourceArn":
            return Optional.ofNullable(clazz.cast(consumableResourceArn()));
        case "totalQuantity":
            return Optional.ofNullable(clazz.cast(totalQuantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResourceName", CONSUMABLE_RESOURCE_NAME_FIELD);
        map.put("consumableResourceArn", CONSUMABLE_RESOURCE_ARN_FIELD);
        map.put("totalQuantity", TOTAL_QUANTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConsumableResourceResponse, T> g) {
        return obj -> g.apply((UpdateConsumableResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConsumableResourceResponse> {
        /**
         * <p>
         * The name of the consumable resource to be updated.
         * </p>
         * 
         * @param consumableResourceName
         *        The name of the consumable resource to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceName(String consumableResourceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the consumable resource.
         * </p>
         * 
         * @param consumableResourceArn
         *        The Amazon Resource Name (ARN) of the consumable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceArn(String consumableResourceArn);

        /**
         * <p>
         * The total amount of the consumable resource that is available.
         * </p>
         * 
         * @param totalQuantity
         *        The total amount of the consumable resource that is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalQuantity(Long totalQuantity);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private String consumableResourceName;

        private String consumableResourceArn;

        private Long totalQuantity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConsumableResourceResponse model) {
            super(model);
            consumableResourceName(model.consumableResourceName);
            consumableResourceArn(model.consumableResourceArn);
            totalQuantity(model.totalQuantity);
        }

        public final String getConsumableResourceName() {
            return consumableResourceName;
        }

        public final void setConsumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
        }

        @Override
        public final Builder consumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
            return this;
        }

        public final String getConsumableResourceArn() {
            return consumableResourceArn;
        }

        public final void setConsumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
        }

        @Override
        public final Builder consumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
            return this;
        }

        public final Long getTotalQuantity() {
            return totalQuantity;
        }

        public final void setTotalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
        }

        @Override
        public final Builder totalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        @Override
        public UpdateConsumableResourceResponse build() {
            return new UpdateConsumableResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
