/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the weights for the fair share identifiers for the fair share policy. Fair share identifiers that aren't
 * included have a default weight of <code>1.0</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareAttributes implements SdkPojo, Serializable, ToCopyableBuilder<ShareAttributes.Builder, ShareAttributes> {
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareIdentifier").getter(getter(ShareAttributes::shareIdentifier))
            .setter(setter(Builder::shareIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()).build();

    private static final SdkField<Float> WEIGHT_FACTOR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("weightFactor").getter(getter(ShareAttributes::weightFactor)).setter(setter(Builder::weightFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weightFactor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_IDENTIFIER_FIELD,
            WEIGHT_FACTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String shareIdentifier;

    private final Float weightFactor;

    private ShareAttributes(BuilderImpl builder) {
        this.shareIdentifier = builder.shareIdentifier;
        this.weightFactor = builder.weightFactor;
    }

    /**
     * <p>
     * A fair share identifier or fair share identifier prefix. If the string ends with an asterisk (*), this entry
     * specifies the weight factor to use for fair share identifiers that start with that prefix. The list of fair share
     * identifiers in a fair share policy can't overlap. For example, you can't have one that specifies a
     * <code>shareIdentifier</code> of <code>UserA*</code> and another that specifies a <code>shareIdentifier</code> of
     * <code>UserA-1</code>.
     * </p>
     * <p>
     * There can be no more than 500 fair share identifiers active in a job queue.
     * </p>
     * <p>
     * The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
     * </p>
     * 
     * @return A fair share identifier or fair share identifier prefix. If the string ends with an asterisk (*), this
     *         entry specifies the weight factor to use for fair share identifiers that start with that prefix. The list
     *         of fair share identifiers in a fair share policy can't overlap. For example, you can't have one that
     *         specifies a <code>shareIdentifier</code> of <code>UserA*</code> and another that specifies a
     *         <code>shareIdentifier</code> of <code>UserA-1</code>.</p>
     *         <p>
     *         There can be no more than 500 fair share identifiers active in a job queue.
     *         </p>
     *         <p>
     *         The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
     */
    public final String shareIdentifier() {
        return shareIdentifier;
    }

    /**
     * <p>
     * The weight factor for the fair share identifier. The default value is 1.0. A lower value has a higher priority
     * for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8
     * times the compute resources of jobs that use a share identifier with a weight factor of 1.
     * </p>
     * <p>
     * The smallest supported value is 0.0001, and the largest supported value is 999.9999.
     * </p>
     * 
     * @return The weight factor for the fair share identifier. The default value is 1.0. A lower value has a higher
     *         priority for compute resources. For example, jobs that use a share identifier with a weight factor of
     *         0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of
     *         1.</p>
     *         <p>
     *         The smallest supported value is 0.0001, and the largest supported value is 999.9999.
     */
    public final Float weightFactor() {
        return weightFactor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(weightFactor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareAttributes)) {
            return false;
        }
        ShareAttributes other = (ShareAttributes) obj;
        return Objects.equals(shareIdentifier(), other.shareIdentifier()) && Objects.equals(weightFactor(), other.weightFactor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareAttributes").add("ShareIdentifier", shareIdentifier()).add("WeightFactor", weightFactor())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "shareIdentifier":
            return Optional.ofNullable(clazz.cast(shareIdentifier()));
        case "weightFactor":
            return Optional.ofNullable(clazz.cast(weightFactor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("weightFactor", WEIGHT_FACTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShareAttributes, T> g) {
        return obj -> g.apply((ShareAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShareAttributes> {
        /**
         * <p>
         * A fair share identifier or fair share identifier prefix. If the string ends with an asterisk (*), this entry
         * specifies the weight factor to use for fair share identifiers that start with that prefix. The list of fair
         * share identifiers in a fair share policy can't overlap. For example, you can't have one that specifies a
         * <code>shareIdentifier</code> of <code>UserA*</code> and another that specifies a <code>shareIdentifier</code>
         * of <code>UserA-1</code>.
         * </p>
         * <p>
         * There can be no more than 500 fair share identifiers active in a job queue.
         * </p>
         * <p>
         * The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
         * </p>
         * 
         * @param shareIdentifier
         *        A fair share identifier or fair share identifier prefix. If the string ends with an asterisk (*), this
         *        entry specifies the weight factor to use for fair share identifiers that start with that prefix. The
         *        list of fair share identifiers in a fair share policy can't overlap. For example, you can't have one
         *        that specifies a <code>shareIdentifier</code> of <code>UserA*</code> and another that specifies a
         *        <code>shareIdentifier</code> of <code>UserA-1</code>.</p>
         *        <p>
         *        There can be no more than 500 fair share identifiers active in a job queue.
         *        </p>
         *        <p>
         *        The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareIdentifier(String shareIdentifier);

        /**
         * <p>
         * The weight factor for the fair share identifier. The default value is 1.0. A lower value has a higher
         * priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125
         * (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.
         * </p>
         * <p>
         * The smallest supported value is 0.0001, and the largest supported value is 999.9999.
         * </p>
         * 
         * @param weightFactor
         *        The weight factor for the fair share identifier. The default value is 1.0. A lower value has a higher
         *        priority for compute resources. For example, jobs that use a share identifier with a weight factor of
         *        0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor
         *        of 1.</p>
         *        <p>
         *        The smallest supported value is 0.0001, and the largest supported value is 999.9999.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightFactor(Float weightFactor);
    }

    static final class BuilderImpl implements Builder {
        private String shareIdentifier;

        private Float weightFactor;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareAttributes model) {
            shareIdentifier(model.shareIdentifier);
            weightFactor(model.weightFactor);
        }

        public final String getShareIdentifier() {
            return shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final Float getWeightFactor() {
            return weightFactor;
        }

        public final void setWeightFactor(Float weightFactor) {
            this.weightFactor = weightFactor;
        }

        @Override
        public final Builder weightFactor(Float weightFactor) {
            this.weightFactor = weightFactor;
            return this;
        }

        @Override
        public ShareAttributes build() {
            return new ShareAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
