/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComputeEnvironmentResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, CreateComputeEnvironmentResponse> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeEnvironmentName").getter(CreateComputeEnvironmentResponse.getter(CreateComputeEnvironmentResponse::computeEnvironmentName)).setter(CreateComputeEnvironmentResponse.setter(Builder::computeEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentName").build()}).build();
    private static final SdkField<String> COMPUTE_ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeEnvironmentArn").getter(CreateComputeEnvironmentResponse.getter(CreateComputeEnvironmentResponse::computeEnvironmentArn)).setter(CreateComputeEnvironmentResponse.setter(Builder::computeEnvironmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENT_NAME_FIELD, COMPUTE_ENVIRONMENT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateComputeEnvironmentResponse.memberNameToFieldInitializer();
    private final String computeEnvironmentName;
    private final String computeEnvironmentArn;

    private CreateComputeEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
    }

    public final String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public final String computeEnvironmentArn() {
        return this.computeEnvironmentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeEnvironmentResponse)) {
            return false;
        }
        CreateComputeEnvironmentResponse other = (CreateComputeEnvironmentResponse)((Object)obj);
        return Objects.equals(this.computeEnvironmentName(), other.computeEnvironmentName()) && Objects.equals(this.computeEnvironmentArn(), other.computeEnvironmentArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComputeEnvironmentResponse").add("ComputeEnvironmentName", (Object)this.computeEnvironmentName()).add("ComputeEnvironmentArn", (Object)this.computeEnvironmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentName()));
            }
            case "computeEnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("computeEnvironmentName", COMPUTE_ENVIRONMENT_NAME_FIELD);
        map.put("computeEnvironmentArn", COMPUTE_ENVIRONMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateComputeEnvironmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String computeEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeEnvironmentResponse model) {
            super(model);
            this.computeEnvironmentName(model.computeEnvironmentName);
            this.computeEnvironmentArn(model.computeEnvironmentArn);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final String getComputeEnvironmentArn() {
            return this.computeEnvironmentArn;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        @Override
        public CreateComputeEnvironmentResponse build() {
            return new CreateComputeEnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComputeEnvironmentResponse> {
        public Builder computeEnvironmentName(String var1);

        public Builder computeEnvironmentArn(String var1);
    }
}

