/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.model.EcsProperties;
import software.amazon.awssdk.services.batch.model.EksProperties;
import software.amazon.awssdk.services.batch.model.JobTimeout;
import software.amazon.awssdk.services.batch.model.NodeProperties;
import software.amazon.awssdk.services.batch.model.OrchestrationType;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.PlatformCapability;
import software.amazon.awssdk.services.batch.model.PlatformCapabilityListCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDefinition> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDefinitionName").getter(JobDefinition.getter(JobDefinition::jobDefinitionName)).setter(JobDefinition.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionName").build()}).build();
    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDefinitionArn").getter(JobDefinition.getter(JobDefinition::jobDefinitionArn)).setter(JobDefinition.setter(Builder::jobDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionArn").build()}).build();
    private static final SdkField<Integer> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("revision").getter(JobDefinition.getter(JobDefinition::revision)).setter(JobDefinition.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobDefinition.getter(JobDefinition::status)).setter(JobDefinition.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(JobDefinition.getter(JobDefinition::type)).setter(JobDefinition.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Integer> SCHEDULING_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schedulingPriority").getter(JobDefinition.getter(JobDefinition::schedulingPriority)).setter(JobDefinition.setter(Builder::schedulingPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPriority").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(JobDefinition.getter(JobDefinition::parameters)).setter(JobDefinition.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryStrategy").getter(JobDefinition.getter(JobDefinition::retryStrategy)).setter(JobDefinition.setter(Builder::retryStrategy)).constructor(RetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()}).build();
    private static final SdkField<ContainerProperties> CONTAINER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerProperties").getter(JobDefinition.getter(JobDefinition::containerProperties)).setter(JobDefinition.setter(Builder::containerProperties)).constructor(ContainerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerProperties").build()}).build();
    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeout").getter(JobDefinition.getter(JobDefinition::timeout)).setter(JobDefinition.setter(Builder::timeout)).constructor(JobTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final SdkField<NodeProperties> NODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeProperties").getter(JobDefinition.getter(JobDefinition::nodeProperties)).setter(JobDefinition.setter(Builder::nodeProperties)).constructor(NodeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(JobDefinition.getter(JobDefinition::tags)).setter(JobDefinition.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("propagateTags").getter(JobDefinition.getter(JobDefinition::propagateTags)).setter(JobDefinition.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<List<String>> PLATFORM_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platformCapabilities").getter(JobDefinition.getter(JobDefinition::platformCapabilitiesAsStrings)).setter(JobDefinition.setter(Builder::platformCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EcsProperties> ECS_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecsProperties").getter(JobDefinition.getter(JobDefinition::ecsProperties)).setter(JobDefinition.setter(Builder::ecsProperties)).constructor(EcsProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsProperties").build()}).build();
    private static final SdkField<EksProperties> EKS_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksProperties").getter(JobDefinition.getter(JobDefinition::eksProperties)).setter(JobDefinition.setter(Builder::eksProperties)).constructor(EksProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksProperties").build()}).build();
    private static final SdkField<String> CONTAINER_ORCHESTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerOrchestrationType").getter(JobDefinition.getter(JobDefinition::containerOrchestrationTypeAsString)).setter(JobDefinition.setter(Builder::containerOrchestrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOrchestrationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD, JOB_DEFINITION_ARN_FIELD, REVISION_FIELD, STATUS_FIELD, TYPE_FIELD, SCHEDULING_PRIORITY_FIELD, PARAMETERS_FIELD, RETRY_STRATEGY_FIELD, CONTAINER_PROPERTIES_FIELD, TIMEOUT_FIELD, NODE_PROPERTIES_FIELD, TAGS_FIELD, PROPAGATE_TAGS_FIELD, PLATFORM_CAPABILITIES_FIELD, ECS_PROPERTIES_FIELD, EKS_PROPERTIES_FIELD, CONTAINER_ORCHESTRATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobDefinitionName;
    private final String jobDefinitionArn;
    private final Integer revision;
    private final String status;
    private final String type;
    private final Integer schedulingPriority;
    private final Map<String, String> parameters;
    private final RetryStrategy retryStrategy;
    private final ContainerProperties containerProperties;
    private final JobTimeout timeout;
    private final NodeProperties nodeProperties;
    private final Map<String, String> tags;
    private final Boolean propagateTags;
    private final List<String> platformCapabilities;
    private final EcsProperties ecsProperties;
    private final EksProperties eksProperties;
    private final String containerOrchestrationType;

    private JobDefinition(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
        this.status = builder.status;
        this.type = builder.type;
        this.schedulingPriority = builder.schedulingPriority;
        this.parameters = builder.parameters;
        this.retryStrategy = builder.retryStrategy;
        this.containerProperties = builder.containerProperties;
        this.timeout = builder.timeout;
        this.nodeProperties = builder.nodeProperties;
        this.tags = builder.tags;
        this.propagateTags = builder.propagateTags;
        this.platformCapabilities = builder.platformCapabilities;
        this.ecsProperties = builder.ecsProperties;
        this.eksProperties = builder.eksProperties;
        this.containerOrchestrationType = builder.containerOrchestrationType;
    }

    public final String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public final String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public final Integer revision() {
        return this.revision;
    }

    public final String status() {
        return this.status;
    }

    public final String type() {
        return this.type;
    }

    public final Integer schedulingPriority() {
        return this.schedulingPriority;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final ContainerProperties containerProperties() {
        return this.containerProperties;
    }

    public final JobTimeout timeout() {
        return this.timeout;
    }

    public final NodeProperties nodeProperties() {
        return this.nodeProperties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean propagateTags() {
        return this.propagateTags;
    }

    public final List<PlatformCapability> platformCapabilities() {
        return PlatformCapabilityListCopier.copyStringToEnum(this.platformCapabilities);
    }

    public final boolean hasPlatformCapabilities() {
        return this.platformCapabilities != null && !(this.platformCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> platformCapabilitiesAsStrings() {
        return this.platformCapabilities;
    }

    public final EcsProperties ecsProperties() {
        return this.ecsProperties;
    }

    public final EksProperties eksProperties() {
        return this.eksProperties;
    }

    public final OrchestrationType containerOrchestrationType() {
        return OrchestrationType.fromValue(this.containerOrchestrationType);
    }

    public final String containerOrchestrationTypeAsString() {
        return this.containerOrchestrationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformCapabilities() ? this.platformCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerOrchestrationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDefinition)) {
            return false;
        }
        JobDefinition other = (JobDefinition)obj;
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.schedulingPriority(), other.schedulingPriority()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.containerProperties(), other.containerProperties()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.nodeProperties(), other.nodeProperties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.propagateTags(), other.propagateTags()) && this.hasPlatformCapabilities() == other.hasPlatformCapabilities() && Objects.equals(this.platformCapabilitiesAsStrings(), other.platformCapabilitiesAsStrings()) && Objects.equals(this.ecsProperties(), other.ecsProperties()) && Objects.equals(this.eksProperties(), other.eksProperties()) && Objects.equals(this.containerOrchestrationTypeAsString(), other.containerOrchestrationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JobDefinition").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("JobDefinitionArn", (Object)this.jobDefinitionArn()).add("Revision", (Object)this.revision()).add("Status", (Object)this.status()).add("Type", (Object)this.type()).add("SchedulingPriority", (Object)this.schedulingPriority()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("RetryStrategy", (Object)this.retryStrategy()).add("ContainerProperties", (Object)this.containerProperties()).add("Timeout", (Object)this.timeout()).add("NodeProperties", (Object)this.nodeProperties()).add("Tags", this.hasTags() ? this.tags() : null).add("PropagateTags", (Object)this.propagateTags()).add("PlatformCapabilities", this.hasPlatformCapabilities() ? this.platformCapabilitiesAsStrings() : null).add("EcsProperties", (Object)this.ecsProperties()).add("EksProperties", (Object)this.eksProperties()).add("ContainerOrchestrationType", (Object)this.containerOrchestrationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "jobDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionArn()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "schedulingPriority": {
                return Optional.ofNullable(clazz.cast(this.schedulingPriority()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "retryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "containerProperties": {
                return Optional.ofNullable(clazz.cast(this.containerProperties()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "nodeProperties": {
                return Optional.ofNullable(clazz.cast(this.nodeProperties()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTags()));
            }
            case "platformCapabilities": {
                return Optional.ofNullable(clazz.cast(this.platformCapabilitiesAsStrings()));
            }
            case "ecsProperties": {
                return Optional.ofNullable(clazz.cast(this.ecsProperties()));
            }
            case "eksProperties": {
                return Optional.ofNullable(clazz.cast(this.eksProperties()));
            }
            case "containerOrchestrationType": {
                return Optional.ofNullable(clazz.cast(this.containerOrchestrationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobDefinitionName", JOB_DEFINITION_NAME_FIELD);
        map.put("jobDefinitionArn", JOB_DEFINITION_ARN_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("schedulingPriority", SCHEDULING_PRIORITY_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("retryStrategy", RETRY_STRATEGY_FIELD);
        map.put("containerProperties", CONTAINER_PROPERTIES_FIELD);
        map.put("timeout", TIMEOUT_FIELD);
        map.put("nodeProperties", NODE_PROPERTIES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("propagateTags", PROPAGATE_TAGS_FIELD);
        map.put("platformCapabilities", PLATFORM_CAPABILITIES_FIELD);
        map.put("ecsProperties", ECS_PROPERTIES_FIELD);
        map.put("eksProperties", EKS_PROPERTIES_FIELD);
        map.put("containerOrchestrationType", CONTAINER_ORCHESTRATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobDefinition, T> g) {
        return obj -> g.apply((JobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String jobDefinitionArn;
        private Integer revision;
        private String status;
        private String type;
        private Integer schedulingPriority;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private RetryStrategy retryStrategy;
        private ContainerProperties containerProperties;
        private JobTimeout timeout;
        private NodeProperties nodeProperties;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean propagateTags;
        private List<String> platformCapabilities = DefaultSdkAutoConstructList.getInstance();
        private EcsProperties ecsProperties;
        private EksProperties eksProperties;
        private String containerOrchestrationType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDefinition model) {
            this.jobDefinitionName(model.jobDefinitionName);
            this.jobDefinitionArn(model.jobDefinitionArn);
            this.revision(model.revision);
            this.status(model.status);
            this.type(model.type);
            this.schedulingPriority(model.schedulingPriority);
            this.parameters(model.parameters);
            this.retryStrategy(model.retryStrategy);
            this.containerProperties(model.containerProperties);
            this.timeout(model.timeout);
            this.nodeProperties(model.nodeProperties);
            this.tags(model.tags);
            this.propagateTags(model.propagateTags);
            this.platformCapabilitiesWithStrings(model.platformCapabilities);
            this.ecsProperties(model.ecsProperties);
            this.eksProperties(model.eksProperties);
            this.containerOrchestrationType(model.containerOrchestrationType);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Integer getSchedulingPriority() {
            return this.schedulingPriority;
        }

        public final void setSchedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
        }

        @Override
        public final Builder schedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return this.containerProperties != null ? this.containerProperties.toBuilder() : null;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final JobTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final NodeProperties.Builder getNodeProperties() {
            return this.nodeProperties != null ? this.nodeProperties.toBuilder() : null;
        }

        public final void setNodeProperties(NodeProperties.BuilderImpl nodeProperties) {
            this.nodeProperties = nodeProperties != null ? nodeProperties.build() : null;
        }

        @Override
        public final Builder nodeProperties(NodeProperties nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final Boolean getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public final Collection<String> getPlatformCapabilities() {
            if (this.platformCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformCapabilities;
        }

        public final void setPlatformCapabilities(Collection<String> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copy(platformCapabilities);
        }

        @Override
        public final Builder platformCapabilitiesWithStrings(Collection<String> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copy(platformCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformCapabilitiesWithStrings(String ... platformCapabilities) {
            this.platformCapabilitiesWithStrings(Arrays.asList(platformCapabilities));
            return this;
        }

        @Override
        public final Builder platformCapabilities(Collection<PlatformCapability> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copyEnumToString(platformCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformCapabilities(PlatformCapability ... platformCapabilities) {
            this.platformCapabilities(Arrays.asList(platformCapabilities));
            return this;
        }

        public final EcsProperties.Builder getEcsProperties() {
            return this.ecsProperties != null ? this.ecsProperties.toBuilder() : null;
        }

        public final void setEcsProperties(EcsProperties.BuilderImpl ecsProperties) {
            this.ecsProperties = ecsProperties != null ? ecsProperties.build() : null;
        }

        @Override
        public final Builder ecsProperties(EcsProperties ecsProperties) {
            this.ecsProperties = ecsProperties;
            return this;
        }

        public final EksProperties.Builder getEksProperties() {
            return this.eksProperties != null ? this.eksProperties.toBuilder() : null;
        }

        public final void setEksProperties(EksProperties.BuilderImpl eksProperties) {
            this.eksProperties = eksProperties != null ? eksProperties.build() : null;
        }

        @Override
        public final Builder eksProperties(EksProperties eksProperties) {
            this.eksProperties = eksProperties;
            return this;
        }

        public final String getContainerOrchestrationType() {
            return this.containerOrchestrationType;
        }

        public final void setContainerOrchestrationType(String containerOrchestrationType) {
            this.containerOrchestrationType = containerOrchestrationType;
        }

        @Override
        public final Builder containerOrchestrationType(String containerOrchestrationType) {
            this.containerOrchestrationType = containerOrchestrationType;
            return this;
        }

        @Override
        public final Builder containerOrchestrationType(OrchestrationType containerOrchestrationType) {
            this.containerOrchestrationType(containerOrchestrationType == null ? null : containerOrchestrationType.toString());
            return this;
        }

        public JobDefinition build() {
            return new JobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDefinition> {
        public Builder jobDefinitionName(String var1);

        public Builder jobDefinitionArn(String var1);

        public Builder revision(Integer var1);

        public Builder status(String var1);

        public Builder type(String var1);

        public Builder schedulingPriority(Integer var1);

        public Builder parameters(Map<String, String> var1);

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder containerProperties(ContainerProperties var1);

        default public Builder containerProperties(Consumer<ContainerProperties.Builder> containerProperties) {
            return this.containerProperties((ContainerProperties)((ContainerProperties.Builder)ContainerProperties.builder().applyMutation(containerProperties)).build());
        }

        public Builder timeout(JobTimeout var1);

        default public Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return this.timeout((JobTimeout)((JobTimeout.Builder)JobTimeout.builder().applyMutation(timeout)).build());
        }

        public Builder nodeProperties(NodeProperties var1);

        default public Builder nodeProperties(Consumer<NodeProperties.Builder> nodeProperties) {
            return this.nodeProperties((NodeProperties)((NodeProperties.Builder)NodeProperties.builder().applyMutation(nodeProperties)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder propagateTags(Boolean var1);

        public Builder platformCapabilitiesWithStrings(Collection<String> var1);

        public Builder platformCapabilitiesWithStrings(String ... var1);

        public Builder platformCapabilities(Collection<PlatformCapability> var1);

        public Builder platformCapabilities(PlatformCapability ... var1);

        public Builder ecsProperties(EcsProperties var1);

        default public Builder ecsProperties(Consumer<EcsProperties.Builder> ecsProperties) {
            return this.ecsProperties((EcsProperties)((EcsProperties.Builder)EcsProperties.builder().applyMutation(ecsProperties)).build());
        }

        public Builder eksProperties(EksProperties var1);

        default public Builder eksProperties(Consumer<EksProperties.Builder> eksProperties) {
            return this.eksProperties((EksProperties)((EksProperties.Builder)EksProperties.builder().applyMutation(eksProperties)).build());
        }

        public Builder containerOrchestrationType(String var1);

        public Builder containerOrchestrationType(OrchestrationType var1);
    }
}

