/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EcsTaskDetails;
import software.amazon.awssdk.services.batch.model.ListEcsTaskDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsPropertiesDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsPropertiesDetail> {
    private static final SdkField<List<EcsTaskDetails>> TASK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskProperties").getter(EcsPropertiesDetail.getter(EcsPropertiesDetail::taskProperties)).setter(EcsPropertiesDetail.setter(Builder::taskProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsTaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("taskProperties", TASK_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<EcsTaskDetails> taskProperties;

    private EcsPropertiesDetail(BuilderImpl builder) {
        this.taskProperties = builder.taskProperties;
    }

    public final boolean hasTaskProperties() {
        return this.taskProperties != null && !(this.taskProperties instanceof SdkAutoConstructList);
    }

    public final List<EcsTaskDetails> taskProperties() {
        return this.taskProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskProperties() ? this.taskProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsPropertiesDetail)) {
            return false;
        }
        EcsPropertiesDetail other = (EcsPropertiesDetail)obj;
        return this.hasTaskProperties() == other.hasTaskProperties() && Objects.equals(this.taskProperties(), other.taskProperties());
    }

    public final String toString() {
        return ToString.builder((String)"EcsPropertiesDetail").add("TaskProperties", this.hasTaskProperties() ? this.taskProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskProperties": {
                return Optional.ofNullable(clazz.cast(this.taskProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EcsPropertiesDetail, T> g) {
        return obj -> g.apply((EcsPropertiesDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EcsTaskDetails> taskProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsPropertiesDetail model) {
            this.taskProperties(model.taskProperties);
        }

        public final List<EcsTaskDetails.Builder> getTaskProperties() {
            List<EcsTaskDetails.Builder> result = ListEcsTaskDetailsCopier.copyToBuilder(this.taskProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskProperties(Collection<EcsTaskDetails.BuilderImpl> taskProperties) {
            this.taskProperties = ListEcsTaskDetailsCopier.copyFromBuilder(taskProperties);
        }

        @Override
        public final Builder taskProperties(Collection<EcsTaskDetails> taskProperties) {
            this.taskProperties = ListEcsTaskDetailsCopier.copy(taskProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(EcsTaskDetails ... taskProperties) {
            this.taskProperties(Arrays.asList(taskProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(Consumer<EcsTaskDetails.Builder> ... taskProperties) {
            this.taskProperties(Stream.of(taskProperties).map(c -> (EcsTaskDetails)((EcsTaskDetails.Builder)EcsTaskDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EcsPropertiesDetail build() {
            return new EcsPropertiesDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsPropertiesDetail> {
        public Builder taskProperties(Collection<EcsTaskDetails> var1);

        public Builder taskProperties(EcsTaskDetails ... var1);

        public Builder taskProperties(Consumer<EcsTaskDetails.Builder> ... var1);
    }
}

