/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.model.EcsProperties;
import software.amazon.awssdk.services.batch.model.EksProperties;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeRangeProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeRangeProperty> {
    private static final SdkField<String> TARGET_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetNodes").getter(NodeRangeProperty.getter(NodeRangeProperty::targetNodes)).setter(NodeRangeProperty.setter(Builder::targetNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNodes").build()}).build();
    private static final SdkField<ContainerProperties> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("container").getter(NodeRangeProperty.getter(NodeRangeProperty::container)).setter(NodeRangeProperty.setter(Builder::container)).constructor(ContainerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceTypes").getter(NodeRangeProperty.getter(NodeRangeProperty::instanceTypes)).setter(NodeRangeProperty.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EcsProperties> ECS_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecsProperties").getter(NodeRangeProperty.getter(NodeRangeProperty::ecsProperties)).setter(NodeRangeProperty.setter(Builder::ecsProperties)).constructor(EcsProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsProperties").build()}).build();
    private static final SdkField<EksProperties> EKS_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksProperties").getter(NodeRangeProperty.getter(NodeRangeProperty::eksProperties)).setter(NodeRangeProperty.setter(Builder::eksProperties)).constructor(EksProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODES_FIELD, CONTAINER_FIELD, INSTANCE_TYPES_FIELD, ECS_PROPERTIES_FIELD, EKS_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("targetNodes", TARGET_NODES_FIELD);
            this.put("container", CONTAINER_FIELD);
            this.put("instanceTypes", INSTANCE_TYPES_FIELD);
            this.put("ecsProperties", ECS_PROPERTIES_FIELD);
            this.put("eksProperties", EKS_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String targetNodes;
    private final ContainerProperties container;
    private final List<String> instanceTypes;
    private final EcsProperties ecsProperties;
    private final EksProperties eksProperties;

    private NodeRangeProperty(BuilderImpl builder) {
        this.targetNodes = builder.targetNodes;
        this.container = builder.container;
        this.instanceTypes = builder.instanceTypes;
        this.ecsProperties = builder.ecsProperties;
        this.eksProperties = builder.eksProperties;
    }

    public final String targetNodes() {
        return this.targetNodes;
    }

    public final ContainerProperties container() {
        return this.container;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public final EcsProperties ecsProperties() {
        return this.ecsProperties;
    }

    public final EksProperties eksProperties() {
        return this.eksProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRangeProperty)) {
            return false;
        }
        NodeRangeProperty other = (NodeRangeProperty)obj;
        return Objects.equals(this.targetNodes(), other.targetNodes()) && Objects.equals(this.container(), other.container()) && this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.ecsProperties(), other.ecsProperties()) && Objects.equals(this.eksProperties(), other.eksProperties());
    }

    public final String toString() {
        return ToString.builder((String)"NodeRangeProperty").add("TargetNodes", (Object)this.targetNodes()).add("Container", (Object)this.container()).add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("EcsProperties", (Object)this.ecsProperties()).add("EksProperties", (Object)this.eksProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetNodes": {
                return Optional.ofNullable(clazz.cast(this.targetNodes()));
            }
            case "container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "ecsProperties": {
                return Optional.ofNullable(clazz.cast(this.ecsProperties()));
            }
            case "eksProperties": {
                return Optional.ofNullable(clazz.cast(this.eksProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NodeRangeProperty, T> g) {
        return obj -> g.apply((NodeRangeProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetNodes;
        private ContainerProperties container;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private EcsProperties ecsProperties;
        private EksProperties eksProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRangeProperty model) {
            this.targetNodes(model.targetNodes);
            this.container(model.container);
            this.instanceTypes(model.instanceTypes);
            this.ecsProperties(model.ecsProperties);
            this.eksProperties(model.eksProperties);
        }

        public final String getTargetNodes() {
            return this.targetNodes;
        }

        public final void setTargetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
        }

        @Override
        public final Builder targetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
            return this;
        }

        public final ContainerProperties.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(ContainerProperties.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(ContainerProperties container) {
            this.container = container;
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final EcsProperties.Builder getEcsProperties() {
            return this.ecsProperties != null ? this.ecsProperties.toBuilder() : null;
        }

        public final void setEcsProperties(EcsProperties.BuilderImpl ecsProperties) {
            this.ecsProperties = ecsProperties != null ? ecsProperties.build() : null;
        }

        @Override
        public final Builder ecsProperties(EcsProperties ecsProperties) {
            this.ecsProperties = ecsProperties;
            return this;
        }

        public final EksProperties.Builder getEksProperties() {
            return this.eksProperties != null ? this.eksProperties.toBuilder() : null;
        }

        public final void setEksProperties(EksProperties.BuilderImpl eksProperties) {
            this.eksProperties = eksProperties != null ? eksProperties.build() : null;
        }

        @Override
        public final Builder eksProperties(EksProperties eksProperties) {
            this.eksProperties = eksProperties;
            return this;
        }

        public NodeRangeProperty build() {
            return new NodeRangeProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeRangeProperty> {
        public Builder targetNodes(String var1);

        public Builder container(ContainerProperties var1);

        default public Builder container(Consumer<ContainerProperties.Builder> container) {
            return this.container((ContainerProperties)((ContainerProperties.Builder)ContainerProperties.builder().applyMutation(container)).build());
        }

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder ecsProperties(EcsProperties var1);

        default public Builder ecsProperties(Consumer<EcsProperties.Builder> ecsProperties) {
            return this.ecsProperties((EcsProperties)((EcsProperties.Builder)EcsProperties.builder().applyMutation(ecsProperties)).build());
        }

        public Builder eksProperties(EksProperties var1);

        default public Builder eksProperties(Consumer<EksProperties.Builder> eksProperties) {
            return this.eksProperties((EksProperties)((EksProperties.Builder)EksProperties.builder().applyMutation(eksProperties)).build());
        }
    }
}

