/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EcsTaskProperties;
import software.amazon.awssdk.services.batch.model.ListEcsTaskPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsProperties> {
    private static final SdkField<List<EcsTaskProperties>> TASK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskProperties").getter(EcsProperties.getter(EcsProperties::taskProperties)).setter(EcsProperties.setter(Builder::taskProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsTaskProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<EcsTaskProperties> taskProperties;

    private EcsProperties(BuilderImpl builder) {
        this.taskProperties = builder.taskProperties;
    }

    public final boolean hasTaskProperties() {
        return this.taskProperties != null && !(this.taskProperties instanceof SdkAutoConstructList);
    }

    public final List<EcsTaskProperties> taskProperties() {
        return this.taskProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskProperties() ? this.taskProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsProperties)) {
            return false;
        }
        EcsProperties other = (EcsProperties)obj;
        return this.hasTaskProperties() == other.hasTaskProperties() && Objects.equals(this.taskProperties(), other.taskProperties());
    }

    public final String toString() {
        return ToString.builder((String)"EcsProperties").add("TaskProperties", this.hasTaskProperties() ? this.taskProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskProperties": {
                return Optional.ofNullable(clazz.cast(this.taskProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsProperties, T> g) {
        return obj -> g.apply((EcsProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EcsTaskProperties> taskProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsProperties model) {
            this.taskProperties(model.taskProperties);
        }

        public final List<EcsTaskProperties.Builder> getTaskProperties() {
            List<EcsTaskProperties.Builder> result = ListEcsTaskPropertiesCopier.copyToBuilder(this.taskProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskProperties(Collection<EcsTaskProperties.BuilderImpl> taskProperties) {
            this.taskProperties = ListEcsTaskPropertiesCopier.copyFromBuilder(taskProperties);
        }

        @Override
        public final Builder taskProperties(Collection<EcsTaskProperties> taskProperties) {
            this.taskProperties = ListEcsTaskPropertiesCopier.copy(taskProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(EcsTaskProperties ... taskProperties) {
            this.taskProperties(Arrays.asList(taskProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(Consumer<EcsTaskProperties.Builder> ... taskProperties) {
            this.taskProperties(Stream.of(taskProperties).map(c -> (EcsTaskProperties)((EcsTaskProperties.Builder)EcsTaskProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EcsProperties build() {
            return new EcsProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsProperties> {
        public Builder taskProperties(Collection<EcsTaskProperties> var1);

        public Builder taskProperties(EcsTaskProperties ... var1);

        public Builder taskProperties(Consumer<EcsTaskProperties.Builder> ... var1);
    }
}

