/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.JobStateTimeLimitActionsAction;
import software.amazon.awssdk.services.batch.model.JobStateTimeLimitActionsState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobStateTimeLimitAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobStateTimeLimitAction> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(JobStateTimeLimitAction.getter(JobStateTimeLimitAction::reason)).setter(JobStateTimeLimitAction.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(JobStateTimeLimitAction.getter(JobStateTimeLimitAction::stateAsString)).setter(JobStateTimeLimitAction.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Integer> MAX_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxTimeSeconds").getter(JobStateTimeLimitAction.getter(JobStateTimeLimitAction::maxTimeSeconds)).setter(JobStateTimeLimitAction.setter(Builder::maxTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTimeSeconds").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(JobStateTimeLimitAction.getter(JobStateTimeLimitAction::actionAsString)).setter(JobStateTimeLimitAction.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, STATE_FIELD, MAX_TIME_SECONDS_FIELD, ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final String state;
    private final Integer maxTimeSeconds;
    private final String action;

    private JobStateTimeLimitAction(BuilderImpl builder) {
        this.reason = builder.reason;
        this.state = builder.state;
        this.maxTimeSeconds = builder.maxTimeSeconds;
        this.action = builder.action;
    }

    public final String reason() {
        return this.reason;
    }

    public final JobStateTimeLimitActionsState state() {
        return JobStateTimeLimitActionsState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer maxTimeSeconds() {
        return this.maxTimeSeconds;
    }

    public final JobStateTimeLimitActionsAction action() {
        return JobStateTimeLimitActionsAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobStateTimeLimitAction)) {
            return false;
        }
        JobStateTimeLimitAction other = (JobStateTimeLimitAction)obj;
        return Objects.equals(this.reason(), other.reason()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.maxTimeSeconds(), other.maxTimeSeconds()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JobStateTimeLimitAction").add("Reason", (Object)this.reason()).add("State", (Object)this.stateAsString()).add("MaxTimeSeconds", (Object)this.maxTimeSeconds()).add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "maxTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxTimeSeconds()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobStateTimeLimitAction, T> g) {
        return obj -> g.apply((JobStateTimeLimitAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reason;
        private String state;
        private Integer maxTimeSeconds;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(JobStateTimeLimitAction model) {
            this.reason(model.reason);
            this.state(model.state);
            this.maxTimeSeconds(model.maxTimeSeconds);
            this.action(model.action);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobStateTimeLimitActionsState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getMaxTimeSeconds() {
            return this.maxTimeSeconds;
        }

        public final void setMaxTimeSeconds(Integer maxTimeSeconds) {
            this.maxTimeSeconds = maxTimeSeconds;
        }

        @Override
        public final Builder maxTimeSeconds(Integer maxTimeSeconds) {
            this.maxTimeSeconds = maxTimeSeconds;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(JobStateTimeLimitActionsAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public JobStateTimeLimitAction build() {
            return new JobStateTimeLimitAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobStateTimeLimitAction> {
        public Builder reason(String var1);

        public Builder state(String var1);

        public Builder state(JobStateTimeLimitActionsState var1);

        public Builder maxTimeSeconds(Integer var1);

        public Builder action(String var1);

        public Builder action(JobStateTimeLimitActionsAction var1);
    }
}

