/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.RetryAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateOnExit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluateOnExit> {
    private static final SdkField<String> ON_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onStatusReason").getter(EvaluateOnExit.getter(EvaluateOnExit::onStatusReason)).setter(EvaluateOnExit.setter(Builder::onStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onStatusReason").build()}).build();
    private static final SdkField<String> ON_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onReason").getter(EvaluateOnExit.getter(EvaluateOnExit::onReason)).setter(EvaluateOnExit.setter(Builder::onReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onReason").build()}).build();
    private static final SdkField<String> ON_EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onExitCode").getter(EvaluateOnExit.getter(EvaluateOnExit::onExitCode)).setter(EvaluateOnExit.setter(Builder::onExitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onExitCode").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(EvaluateOnExit.getter(EvaluateOnExit::actionAsString)).setter(EvaluateOnExit.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_STATUS_REASON_FIELD, ON_REASON_FIELD, ON_EXIT_CODE_FIELD, ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String onStatusReason;
    private final String onReason;
    private final String onExitCode;
    private final String action;

    private EvaluateOnExit(BuilderImpl builder) {
        this.onStatusReason = builder.onStatusReason;
        this.onReason = builder.onReason;
        this.onExitCode = builder.onExitCode;
        this.action = builder.action;
    }

    public final String onStatusReason() {
        return this.onStatusReason;
    }

    public final String onReason() {
        return this.onReason;
    }

    public final String onExitCode() {
        return this.onExitCode;
    }

    public final RetryAction action() {
        return RetryAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.onStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.onReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.onExitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateOnExit)) {
            return false;
        }
        EvaluateOnExit other = (EvaluateOnExit)obj;
        return Objects.equals(this.onStatusReason(), other.onStatusReason()) && Objects.equals(this.onReason(), other.onReason()) && Objects.equals(this.onExitCode(), other.onExitCode()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateOnExit").add("OnStatusReason", (Object)this.onStatusReason()).add("OnReason", (Object)this.onReason()).add("OnExitCode", (Object)this.onExitCode()).add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "onStatusReason": {
                return Optional.ofNullable(clazz.cast(this.onStatusReason()));
            }
            case "onReason": {
                return Optional.ofNullable(clazz.cast(this.onReason()));
            }
            case "onExitCode": {
                return Optional.ofNullable(clazz.cast(this.onExitCode()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateOnExit, T> g) {
        return obj -> g.apply((EvaluateOnExit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String onStatusReason;
        private String onReason;
        private String onExitCode;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateOnExit model) {
            this.onStatusReason(model.onStatusReason);
            this.onReason(model.onReason);
            this.onExitCode(model.onExitCode);
            this.action(model.action);
        }

        public final String getOnStatusReason() {
            return this.onStatusReason;
        }

        public final void setOnStatusReason(String onStatusReason) {
            this.onStatusReason = onStatusReason;
        }

        @Override
        public final Builder onStatusReason(String onStatusReason) {
            this.onStatusReason = onStatusReason;
            return this;
        }

        public final String getOnReason() {
            return this.onReason;
        }

        public final void setOnReason(String onReason) {
            this.onReason = onReason;
        }

        @Override
        public final Builder onReason(String onReason) {
            this.onReason = onReason;
            return this;
        }

        public final String getOnExitCode() {
            return this.onExitCode;
        }

        public final void setOnExitCode(String onExitCode) {
            this.onExitCode = onExitCode;
        }

        @Override
        public final Builder onExitCode(String onExitCode) {
            this.onExitCode = onExitCode;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RetryAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public EvaluateOnExit build() {
            return new EvaluateOnExit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluateOnExit> {
        public Builder onStatusReason(String var1);

        public Builder onReason(String var1);

        public Builder onExitCode(String var1);

        public Builder action(String var1);

        public Builder action(RetryAction var1);
    }
}

