/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EksContainerEnvironmentVariable;
import software.amazon.awssdk.services.batch.model.EksContainerEnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.EksContainerResourceRequirements;
import software.amazon.awssdk.services.batch.model.EksContainerSecurityContext;
import software.amazon.awssdk.services.batch.model.EksContainerVolumeMount;
import software.amazon.awssdk.services.batch.model.EksContainerVolumeMountsCopier;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksContainer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksContainer> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EksContainer.getter(EksContainer::name)).setter(EksContainer.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(EksContainer.getter(EksContainer::image)).setter(EksContainer.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> IMAGE_PULL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imagePullPolicy").getter(EksContainer.getter(EksContainer::imagePullPolicy)).setter(EksContainer.setter(Builder::imagePullPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePullPolicy").build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(EksContainer.getter(EksContainer::command)).setter(EksContainer.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("args").getter(EksContainer.getter(EksContainer::args)).setter(EksContainer.setter(Builder::args)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("args").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EksContainerEnvironmentVariable>> ENV_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("env").getter(EksContainer.getter(EksContainer::env)).setter(EksContainer.setter(Builder::env)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("env").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksContainerEnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EksContainerResourceRequirements> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resources").getter(EksContainer.getter(EksContainer::resources)).setter(EksContainer.setter(Builder::resources)).constructor(EksContainerResourceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build()}).build();
    private static final SdkField<List<EksContainerVolumeMount>> VOLUME_MOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeMounts").getter(EksContainer.getter(EksContainer::volumeMounts)).setter(EksContainer.setter(Builder::volumeMounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeMounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksContainerVolumeMount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EksContainerSecurityContext> SECURITY_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("securityContext").getter(EksContainer.getter(EksContainer::securityContext)).setter(EksContainer.setter(Builder::securityContext)).constructor(EksContainerSecurityContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_FIELD, IMAGE_PULL_POLICY_FIELD, COMMAND_FIELD, ARGS_FIELD, ENV_FIELD, RESOURCES_FIELD, VOLUME_MOUNTS_FIELD, SECURITY_CONTEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String image;
    private final String imagePullPolicy;
    private final List<String> command;
    private final List<String> args;
    private final List<EksContainerEnvironmentVariable> env;
    private final EksContainerResourceRequirements resources;
    private final List<EksContainerVolumeMount> volumeMounts;
    private final EksContainerSecurityContext securityContext;

    private EksContainer(BuilderImpl builder) {
        this.name = builder.name;
        this.image = builder.image;
        this.imagePullPolicy = builder.imagePullPolicy;
        this.command = builder.command;
        this.args = builder.args;
        this.env = builder.env;
        this.resources = builder.resources;
        this.volumeMounts = builder.volumeMounts;
        this.securityContext = builder.securityContext;
    }

    public final String name() {
        return this.name;
    }

    public final String image() {
        return this.image;
    }

    public final String imagePullPolicy() {
        return this.imagePullPolicy;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final boolean hasArgs() {
        return this.args != null && !(this.args instanceof SdkAutoConstructList);
    }

    public final List<String> args() {
        return this.args;
    }

    public final boolean hasEnv() {
        return this.env != null && !(this.env instanceof SdkAutoConstructList);
    }

    public final List<EksContainerEnvironmentVariable> env() {
        return this.env;
    }

    public final EksContainerResourceRequirements resources() {
        return this.resources;
    }

    public final boolean hasVolumeMounts() {
        return this.volumeMounts != null && !(this.volumeMounts instanceof SdkAutoConstructList);
    }

    public final List<EksContainerVolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public final EksContainerSecurityContext securityContext() {
        return this.securityContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePullPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArgs() ? this.args() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnv() ? this.env() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeMounts() ? this.volumeMounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainer)) {
            return false;
        }
        EksContainer other = (EksContainer)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.imagePullPolicy(), other.imagePullPolicy()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && this.hasArgs() == other.hasArgs() && Objects.equals(this.args(), other.args()) && this.hasEnv() == other.hasEnv() && Objects.equals(this.env(), other.env()) && Objects.equals(this.resources(), other.resources()) && this.hasVolumeMounts() == other.hasVolumeMounts() && Objects.equals(this.volumeMounts(), other.volumeMounts()) && Objects.equals(this.securityContext(), other.securityContext());
    }

    public final String toString() {
        return ToString.builder((String)"EksContainer").add("Name", (Object)this.name()).add("Image", (Object)this.image()).add("ImagePullPolicy", (Object)this.imagePullPolicy()).add("Command", this.hasCommand() ? this.command() : null).add("Args", this.hasArgs() ? this.args() : null).add("Env", this.hasEnv() ? this.env() : null).add("Resources", (Object)this.resources()).add("VolumeMounts", this.hasVolumeMounts() ? this.volumeMounts() : null).add("SecurityContext", (Object)this.securityContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "imagePullPolicy": {
                return Optional.ofNullable(clazz.cast(this.imagePullPolicy()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "args": {
                return Optional.ofNullable(clazz.cast(this.args()));
            }
            case "env": {
                return Optional.ofNullable(clazz.cast(this.env()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "volumeMounts": {
                return Optional.ofNullable(clazz.cast(this.volumeMounts()));
            }
            case "securityContext": {
                return Optional.ofNullable(clazz.cast(this.securityContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksContainer, T> g) {
        return obj -> g.apply((EksContainer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String image;
        private String imagePullPolicy;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private List<String> args = DefaultSdkAutoConstructList.getInstance();
        private List<EksContainerEnvironmentVariable> env = DefaultSdkAutoConstructList.getInstance();
        private EksContainerResourceRequirements resources;
        private List<EksContainerVolumeMount> volumeMounts = DefaultSdkAutoConstructList.getInstance();
        private EksContainerSecurityContext securityContext;

        private BuilderImpl() {
        }

        private BuilderImpl(EksContainer model) {
            this.name(model.name);
            this.image(model.image);
            this.imagePullPolicy(model.imagePullPolicy);
            this.command(model.command);
            this.args(model.args);
            this.env(model.env);
            this.resources(model.resources);
            this.volumeMounts(model.volumeMounts);
            this.securityContext(model.securityContext);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImagePullPolicy() {
            return this.imagePullPolicy;
        }

        public final void setImagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
        }

        @Override
        public final Builder imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final Collection<String> getArgs() {
            if (this.args instanceof SdkAutoConstructList) {
                return null;
            }
            return this.args;
        }

        public final void setArgs(Collection<String> args) {
            this.args = StringListCopier.copy(args);
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = StringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final List<EksContainerEnvironmentVariable.Builder> getEnv() {
            List<EksContainerEnvironmentVariable.Builder> result = EksContainerEnvironmentVariablesCopier.copyToBuilder(this.env);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnv(Collection<EksContainerEnvironmentVariable.BuilderImpl> env) {
            this.env = EksContainerEnvironmentVariablesCopier.copyFromBuilder(env);
        }

        @Override
        public final Builder env(Collection<EksContainerEnvironmentVariable> env) {
            this.env = EksContainerEnvironmentVariablesCopier.copy(env);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder env(EksContainerEnvironmentVariable ... env) {
            this.env(Arrays.asList(env));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder env(Consumer<EksContainerEnvironmentVariable.Builder> ... env) {
            this.env(Stream.of(env).map(c -> (EksContainerEnvironmentVariable)((EksContainerEnvironmentVariable.Builder)EksContainerEnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EksContainerResourceRequirements.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        public final void setResources(EksContainerResourceRequirements.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        @Override
        public final Builder resources(EksContainerResourceRequirements resources) {
            this.resources = resources;
            return this;
        }

        public final List<EksContainerVolumeMount.Builder> getVolumeMounts() {
            List<EksContainerVolumeMount.Builder> result = EksContainerVolumeMountsCopier.copyToBuilder(this.volumeMounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeMounts(Collection<EksContainerVolumeMount.BuilderImpl> volumeMounts) {
            this.volumeMounts = EksContainerVolumeMountsCopier.copyFromBuilder(volumeMounts);
        }

        @Override
        public final Builder volumeMounts(Collection<EksContainerVolumeMount> volumeMounts) {
            this.volumeMounts = EksContainerVolumeMountsCopier.copy(volumeMounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(EksContainerVolumeMount ... volumeMounts) {
            this.volumeMounts(Arrays.asList(volumeMounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(Consumer<EksContainerVolumeMount.Builder> ... volumeMounts) {
            this.volumeMounts(Stream.of(volumeMounts).map(c -> (EksContainerVolumeMount)((EksContainerVolumeMount.Builder)EksContainerVolumeMount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EksContainerSecurityContext.Builder getSecurityContext() {
            return this.securityContext != null ? this.securityContext.toBuilder() : null;
        }

        public final void setSecurityContext(EksContainerSecurityContext.BuilderImpl securityContext) {
            this.securityContext = securityContext != null ? securityContext.build() : null;
        }

        @Override
        public final Builder securityContext(EksContainerSecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public EksContainer build() {
            return new EksContainer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksContainer> {
        public Builder name(String var1);

        public Builder image(String var1);

        public Builder imagePullPolicy(String var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);

        public Builder env(Collection<EksContainerEnvironmentVariable> var1);

        public Builder env(EksContainerEnvironmentVariable ... var1);

        public Builder env(Consumer<EksContainerEnvironmentVariable.Builder> ... var1);

        public Builder resources(EksContainerResourceRequirements var1);

        default public Builder resources(Consumer<EksContainerResourceRequirements.Builder> resources) {
            return this.resources((EksContainerResourceRequirements)((EksContainerResourceRequirements.Builder)EksContainerResourceRequirements.builder().applyMutation(resources)).build());
        }

        public Builder volumeMounts(Collection<EksContainerVolumeMount> var1);

        public Builder volumeMounts(EksContainerVolumeMount ... var1);

        public Builder volumeMounts(Consumer<EksContainerVolumeMount.Builder> ... var1);

        public Builder securityContext(EksContainerSecurityContext var1);

        default public Builder securityContext(Consumer<EksContainerSecurityContext.Builder> securityContext) {
            return this.securityContext((EksContainerSecurityContext)((EksContainerSecurityContext.Builder)EksContainerSecurityContext.builder().applyMutation(securityContext)).build());
        }
    }
}

