/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CEType {
    MANAGED("MANAGED"),
    UNMANAGED("UNMANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CEType> VALUE_MAP;
    private final String value;

    private CEType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CEType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CEType> knownValues() {
        EnumSet<CEType> knownValues = EnumSet.allOf(CEType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CEType.class, CEType::toString);
    }
}

