/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterface> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentId").getter(NetworkInterface.getter(NetworkInterface::attachmentId)).setter(NetworkInterface.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()}).build();
    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipv6Address").getter(NetworkInterface.getter(NetworkInterface::ipv6Address)).setter(NetworkInterface.setter(Builder::ipv6Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Address").build()}).build();
    private static final SdkField<String> PRIVATE_IPV4_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateIpv4Address").getter(NetworkInterface.getter(NetworkInterface::privateIpv4Address)).setter(NetworkInterface.setter(Builder::privateIpv4Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpv4Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, IPV6_ADDRESS_FIELD, PRIVATE_IPV4_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attachmentId;
    private final String ipv6Address;
    private final String privateIpv4Address;

    private NetworkInterface(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.ipv6Address = builder.ipv6Address;
        this.privateIpv4Address = builder.privateIpv4Address;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final String ipv6Address() {
        return this.ipv6Address;
    }

    public final String privateIpv4Address() {
        return this.privateIpv4Address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpv4Address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.ipv6Address(), other.ipv6Address()) && Objects.equals(this.privateIpv4Address(), other.privateIpv4Address());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInterface").add("AttachmentId", (Object)this.attachmentId()).add("Ipv6Address", (Object)this.ipv6Address()).add("PrivateIpv4Address", (Object)this.privateIpv4Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "ipv6Address": {
                return Optional.ofNullable(clazz.cast(this.ipv6Address()));
            }
            case "privateIpv4Address": {
                return Optional.ofNullable(clazz.cast(this.privateIpv4Address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentId;
        private String ipv6Address;
        private String privateIpv4Address;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            this.attachmentId(model.attachmentId);
            this.ipv6Address(model.ipv6Address);
            this.privateIpv4Address(model.privateIpv4Address);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        @Transient
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getIpv6Address() {
            return this.ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        @Transient
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final String getPrivateIpv4Address() {
            return this.privateIpv4Address;
        }

        public final void setPrivateIpv4Address(String privateIpv4Address) {
            this.privateIpv4Address = privateIpv4Address;
        }

        @Override
        @Transient
        public final Builder privateIpv4Address(String privateIpv4Address) {
            this.privateIpv4Address = privateIpv4Address;
            return this;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterface> {
        public Builder attachmentId(String var1);

        public Builder ipv6Address(String var1);

        public Builder privateIpv4Address(String var1);
    }
}

