/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.Device;
import software.amazon.awssdk.services.batch.model.DevicesListCopier;
import software.amazon.awssdk.services.batch.model.Tmpfs;
import software.amazon.awssdk.services.batch.model.TmpfsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinuxParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinuxParameters> {
    private static final SdkField<List<Device>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("devices").getter(LinuxParameters.getter(LinuxParameters::devices)).setter(LinuxParameters.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INIT_PROCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("initProcessEnabled").getter(LinuxParameters.getter(LinuxParameters::initProcessEnabled)).setter(LinuxParameters.setter(Builder::initProcessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initProcessEnabled").build()}).build();
    private static final SdkField<Integer> SHARED_MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sharedMemorySize").getter(LinuxParameters.getter(LinuxParameters::sharedMemorySize)).setter(LinuxParameters.setter(Builder::sharedMemorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedMemorySize").build()}).build();
    private static final SdkField<List<Tmpfs>> TMPFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tmpfs").getter(LinuxParameters.getter(LinuxParameters::tmpfs)).setter(LinuxParameters.setter(Builder::tmpfs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tmpfs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tmpfs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_SWAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSwap").getter(LinuxParameters.getter(LinuxParameters::maxSwap)).setter(LinuxParameters.setter(Builder::maxSwap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSwap").build()}).build();
    private static final SdkField<Integer> SWAPPINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("swappiness").getter(LinuxParameters.getter(LinuxParameters::swappiness)).setter(LinuxParameters.setter(Builder::swappiness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("swappiness").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD, INIT_PROCESS_ENABLED_FIELD, SHARED_MEMORY_SIZE_FIELD, TMPFS_FIELD, MAX_SWAP_FIELD, SWAPPINESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Device> devices;
    private final Boolean initProcessEnabled;
    private final Integer sharedMemorySize;
    private final List<Tmpfs> tmpfs;
    private final Integer maxSwap;
    private final Integer swappiness;

    private LinuxParameters(BuilderImpl builder) {
        this.devices = builder.devices;
        this.initProcessEnabled = builder.initProcessEnabled;
        this.sharedMemorySize = builder.sharedMemorySize;
        this.tmpfs = builder.tmpfs;
        this.maxSwap = builder.maxSwap;
        this.swappiness = builder.swappiness;
    }

    public boolean hasDevices() {
        return this.devices != null && !(this.devices instanceof SdkAutoConstructList);
    }

    public List<Device> devices() {
        return this.devices;
    }

    public Boolean initProcessEnabled() {
        return this.initProcessEnabled;
    }

    public Integer sharedMemorySize() {
        return this.sharedMemorySize;
    }

    public boolean hasTmpfs() {
        return this.tmpfs != null && !(this.tmpfs instanceof SdkAutoConstructList);
    }

    public List<Tmpfs> tmpfs() {
        return this.tmpfs;
    }

    public Integer maxSwap() {
        return this.maxSwap;
    }

    public Integer swappiness() {
        return this.swappiness;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevices() ? this.devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.initProcessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTmpfs() ? this.tmpfs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSwap());
        hashCode = 31 * hashCode + Objects.hashCode(this.swappiness());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinuxParameters)) {
            return false;
        }
        LinuxParameters other = (LinuxParameters)obj;
        return this.hasDevices() == other.hasDevices() && Objects.equals(this.devices(), other.devices()) && Objects.equals(this.initProcessEnabled(), other.initProcessEnabled()) && Objects.equals(this.sharedMemorySize(), other.sharedMemorySize()) && this.hasTmpfs() == other.hasTmpfs() && Objects.equals(this.tmpfs(), other.tmpfs()) && Objects.equals(this.maxSwap(), other.maxSwap()) && Objects.equals(this.swappiness(), other.swappiness());
    }

    public String toString() {
        return ToString.builder((String)"LinuxParameters").add("Devices", this.hasDevices() ? this.devices() : null).add("InitProcessEnabled", (Object)this.initProcessEnabled()).add("SharedMemorySize", (Object)this.sharedMemorySize()).add("Tmpfs", this.hasTmpfs() ? this.tmpfs() : null).add("MaxSwap", (Object)this.maxSwap()).add("Swappiness", (Object)this.swappiness()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
            case "initProcessEnabled": {
                return Optional.ofNullable(clazz.cast(this.initProcessEnabled()));
            }
            case "sharedMemorySize": {
                return Optional.ofNullable(clazz.cast(this.sharedMemorySize()));
            }
            case "tmpfs": {
                return Optional.ofNullable(clazz.cast(this.tmpfs()));
            }
            case "maxSwap": {
                return Optional.ofNullable(clazz.cast(this.maxSwap()));
            }
            case "swappiness": {
                return Optional.ofNullable(clazz.cast(this.swappiness()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinuxParameters, T> g) {
        return obj -> g.apply((LinuxParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Device> devices = DefaultSdkAutoConstructList.getInstance();
        private Boolean initProcessEnabled;
        private Integer sharedMemorySize;
        private List<Tmpfs> tmpfs = DefaultSdkAutoConstructList.getInstance();
        private Integer maxSwap;
        private Integer swappiness;

        private BuilderImpl() {
        }

        private BuilderImpl(LinuxParameters model) {
            this.devices(model.devices);
            this.initProcessEnabled(model.initProcessEnabled);
            this.sharedMemorySize(model.sharedMemorySize);
            this.tmpfs(model.tmpfs);
            this.maxSwap(model.maxSwap);
            this.swappiness(model.swappiness);
        }

        public final Collection<Device.Builder> getDevices() {
            if (this.devices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.devices != null ? (Collection)this.devices.stream().map(Device::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = DevicesListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<Device.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (Device)((Device.Builder)Device.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<Device.BuilderImpl> devices) {
            this.devices = DevicesListCopier.copyFromBuilder(devices);
        }

        public final Boolean getInitProcessEnabled() {
            return this.initProcessEnabled;
        }

        @Override
        public final Builder initProcessEnabled(Boolean initProcessEnabled) {
            this.initProcessEnabled = initProcessEnabled;
            return this;
        }

        public final void setInitProcessEnabled(Boolean initProcessEnabled) {
            this.initProcessEnabled = initProcessEnabled;
        }

        public final Integer getSharedMemorySize() {
            return this.sharedMemorySize;
        }

        @Override
        public final Builder sharedMemorySize(Integer sharedMemorySize) {
            this.sharedMemorySize = sharedMemorySize;
            return this;
        }

        public final void setSharedMemorySize(Integer sharedMemorySize) {
            this.sharedMemorySize = sharedMemorySize;
        }

        public final Collection<Tmpfs.Builder> getTmpfs() {
            if (this.tmpfs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tmpfs != null ? (Collection)this.tmpfs.stream().map(Tmpfs::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tmpfs(Collection<Tmpfs> tmpfs) {
            this.tmpfs = TmpfsListCopier.copy(tmpfs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tmpfs(Tmpfs ... tmpfs) {
            this.tmpfs(Arrays.asList(tmpfs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tmpfs(Consumer<Tmpfs.Builder> ... tmpfs) {
            this.tmpfs(Stream.of(tmpfs).map(c -> (Tmpfs)((Tmpfs.Builder)Tmpfs.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTmpfs(Collection<Tmpfs.BuilderImpl> tmpfs) {
            this.tmpfs = TmpfsListCopier.copyFromBuilder(tmpfs);
        }

        public final Integer getMaxSwap() {
            return this.maxSwap;
        }

        @Override
        public final Builder maxSwap(Integer maxSwap) {
            this.maxSwap = maxSwap;
            return this;
        }

        public final void setMaxSwap(Integer maxSwap) {
            this.maxSwap = maxSwap;
        }

        public final Integer getSwappiness() {
            return this.swappiness;
        }

        @Override
        public final Builder swappiness(Integer swappiness) {
            this.swappiness = swappiness;
            return this;
        }

        public final void setSwappiness(Integer swappiness) {
            this.swappiness = swappiness;
        }

        public LinuxParameters build() {
            return new LinuxParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinuxParameters> {
        public Builder devices(Collection<Device> var1);

        public Builder devices(Device ... var1);

        public Builder devices(Consumer<Device.Builder> ... var1);

        public Builder initProcessEnabled(Boolean var1);

        public Builder sharedMemorySize(Integer var1);

        public Builder tmpfs(Collection<Tmpfs> var1);

        public Builder tmpfs(Tmpfs ... var1);

        public Builder tmpfs(Consumer<Tmpfs.Builder> ... var1);

        public Builder maxSwap(Integer var1);

        public Builder swappiness(Integer var1);
    }
}

