/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ComputeResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComputeResourceMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minvCpus").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxvCpus").isBinary(false).build();
    private static final MarshallingInfo<Integer> DESIREDVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredvCpus").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceTypes").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageId").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnets").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroupIds").isBinary(false).build();
    private static final MarshallingInfo<String> EC2KEYPAIR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2KeyPair").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceRole").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final MarshallingInfo<Integer> BIDPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bidPercentage").isBinary(false).build();
    private static final MarshallingInfo<String> SPOTIAMFLEETROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spotIamFleetRole").isBinary(false).build();
    private static final ComputeResourceMarshaller INSTANCE = new ComputeResourceMarshaller();

    private ComputeResourceMarshaller() {
    }

    public static ComputeResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComputeResource computeResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)computeResource, (String)"computeResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)computeResource.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)computeResource.minvCpus(), MINVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.maxvCpus(), MAXVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.desiredvCpus(), DESIREDVCPUS_BINDING);
            protocolMarshaller.marshall(computeResource.instanceTypes(), INSTANCETYPES_BINDING);
            protocolMarshaller.marshall((Object)computeResource.imageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall(computeResource.subnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(computeResource.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.ec2KeyPair(), EC2KEYPAIR_BINDING);
            protocolMarshaller.marshall((Object)computeResource.instanceRole(), INSTANCEROLE_BINDING);
            protocolMarshaller.marshall(computeResource.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.bidPercentage(), BIDPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)computeResource.spotIamFleetRole(), SPOTIAMFLEETROLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

