/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComputeEnvironmentsResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
    private final List<ComputeEnvironmentDetail> computeEnvironments;
    private final String nextToken;

    private DescribeComputeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.computeEnvironments = builder.computeEnvironments;
        this.nextToken = builder.nextToken;
    }

    public List<ComputeEnvironmentDetail> computeEnvironments() {
        return this.computeEnvironments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsResponse)) {
            return false;
        }
        DescribeComputeEnvironmentsResponse other = (DescribeComputeEnvironmentsResponse)((Object)obj);
        return Objects.equals(this.computeEnvironments(), other.computeEnvironments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeComputeEnvironmentsResponse").add("ComputeEnvironments", this.computeEnvironments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironments": {
                return Optional.of(clazz.cast(this.computeEnvironments()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<ComputeEnvironmentDetail> computeEnvironments;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsResponse model) {
            this.computeEnvironments(model.computeEnvironments);
            this.nextToken(model.nextToken);
        }

        public final Collection<ComputeEnvironmentDetail.Builder> getComputeEnvironments() {
            return this.computeEnvironments != null ? (Collection)this.computeEnvironments.stream().map(ComputeEnvironmentDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(ComputeEnvironmentDetail ... computeEnvironments) {
            this.computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        public final void setComputeEnvironments(Collection<ComputeEnvironmentDetail.BuilderImpl> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copyFromBuilder(computeEnvironments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComputeEnvironmentsResponse build() {
            return new DescribeComputeEnvironmentsResponse(this);
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    CopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
        public Builder computeEnvironments(Collection<ComputeEnvironmentDetail> var1);

        public Builder computeEnvironments(ComputeEnvironmentDetail ... var1);

        public Builder nextToken(String var1);
    }
}

