/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.CRType;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.TagsMapCopier;
import software.amazon.awssdk.services.batch.transform.ComputeResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComputeResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ComputeResource> {
    private final String type;
    private final Integer minvCpus;
    private final Integer maxvCpus;
    private final Integer desiredvCpus;
    private final List<String> instanceTypes;
    private final String imageId;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String ec2KeyPair;
    private final String instanceRole;
    private final Map<String, String> tags;
    private final Integer bidPercentage;
    private final String spotIamFleetRole;

    private ComputeResource(BuilderImpl builder) {
        this.type = builder.type;
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.instanceTypes = builder.instanceTypes;
        this.imageId = builder.imageId;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.ec2KeyPair = builder.ec2KeyPair;
        this.instanceRole = builder.instanceRole;
        this.tags = builder.tags;
        this.bidPercentage = builder.bidPercentage;
        this.spotIamFleetRole = builder.spotIamFleetRole;
    }

    public CRType type() {
        return CRType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Integer minvCpus() {
        return this.minvCpus;
    }

    public Integer maxvCpus() {
        return this.maxvCpus;
    }

    public Integer desiredvCpus() {
        return this.desiredvCpus;
    }

    public List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public String imageId() {
        return this.imageId;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String ec2KeyPair() {
        return this.ec2KeyPair;
    }

    public String instanceRole() {
        return this.instanceRole;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Integer bidPercentage() {
        return this.bidPercentage;
    }

    public String spotIamFleetRole() {
        return this.spotIamFleetRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotIamFleetRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResource)) {
            return false;
        }
        ComputeResource other = (ComputeResource)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.minvCpus(), other.minvCpus()) && Objects.equals(this.maxvCpus(), other.maxvCpus()) && Objects.equals(this.desiredvCpus(), other.desiredvCpus()) && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.ec2KeyPair(), other.ec2KeyPair()) && Objects.equals(this.instanceRole(), other.instanceRole()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.bidPercentage(), other.bidPercentage()) && Objects.equals(this.spotIamFleetRole(), other.spotIamFleetRole());
    }

    public String toString() {
        return ToString.builder((String)"ComputeResource").add("Type", (Object)this.typeString()).add("MinvCpus", (Object)this.minvCpus()).add("MaxvCpus", (Object)this.maxvCpus()).add("DesiredvCpus", (Object)this.desiredvCpus()).add("InstanceTypes", this.instanceTypes()).add("ImageId", (Object)this.imageId()).add("Subnets", this.subnets()).add("SecurityGroupIds", this.securityGroupIds()).add("Ec2KeyPair", (Object)this.ec2KeyPair()).add("InstanceRole", (Object)this.instanceRole()).add("Tags", this.tags()).add("BidPercentage", (Object)this.bidPercentage()).add("SpotIamFleetRole", (Object)this.spotIamFleetRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "minvCpus": {
                return Optional.of(clazz.cast(this.minvCpus()));
            }
            case "maxvCpus": {
                return Optional.of(clazz.cast(this.maxvCpus()));
            }
            case "desiredvCpus": {
                return Optional.of(clazz.cast(this.desiredvCpus()));
            }
            case "instanceTypes": {
                return Optional.of(clazz.cast(this.instanceTypes()));
            }
            case "imageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "ec2KeyPair": {
                return Optional.of(clazz.cast(this.ec2KeyPair()));
            }
            case "instanceRole": {
                return Optional.of(clazz.cast(this.instanceRole()));
            }
            case "tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "bidPercentage": {
                return Optional.of(clazz.cast(this.bidPercentage()));
            }
            case "spotIamFleetRole": {
                return Optional.of(clazz.cast(this.spotIamFleetRole()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer minvCpus;
        private Integer maxvCpus;
        private Integer desiredvCpus;
        private List<String> instanceTypes;
        private String imageId;
        private List<String> subnets;
        private List<String> securityGroupIds;
        private String ec2KeyPair;
        private String instanceRole;
        private Map<String, String> tags;
        private Integer bidPercentage;
        private String spotIamFleetRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResource model) {
            this.type(model.type);
            this.minvCpus(model.minvCpus);
            this.maxvCpus(model.maxvCpus);
            this.desiredvCpus(model.desiredvCpus);
            this.instanceTypes(model.instanceTypes);
            this.imageId(model.imageId);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
            this.ec2KeyPair(model.ec2KeyPair);
            this.instanceRole(model.instanceRole);
            this.tags(model.tags);
            this.bidPercentage(model.bidPercentage);
            this.spotIamFleetRole(model.spotIamFleetRole);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getMinvCpus() {
            return this.minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        public final Integer getMaxvCpus() {
            return this.maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        public final Integer getDesiredvCpus() {
            return this.desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getEc2KeyPair() {
            return this.ec2KeyPair;
        }

        @Override
        public final Builder ec2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        public final void setEc2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final Integer getBidPercentage() {
            return this.bidPercentage;
        }

        @Override
        public final Builder bidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        public final void setBidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
        }

        public final String getSpotIamFleetRole() {
            return this.spotIamFleetRole;
        }

        @Override
        public final Builder spotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
            return this;
        }

        public final void setSpotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
        }

        public ComputeResource build() {
            return new ComputeResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComputeResource> {
        public Builder type(String var1);

        public Builder type(CRType var1);

        public Builder minvCpus(Integer var1);

        public Builder maxvCpus(Integer var1);

        public Builder desiredvCpus(Integer var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder imageId(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder ec2KeyPair(String var1);

        public Builder instanceRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder bidPercentage(Integer var1);

        public Builder spotIamFleetRole(String var1);
    }
}

