/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.batch.model.ContainerOverrides;
import software.amazon.awssdk.services.batch.transform.KeyValuePairUnmarshaller;

public class ContainerOverridesUnmarshaller
implements Unmarshaller<ContainerOverrides, JsonUnmarshallerContext> {
    private static final ContainerOverridesUnmarshaller INSTANCE = new ContainerOverridesUnmarshaller();

    public ContainerOverrides unmarshall(JsonUnmarshallerContext context) throws Exception {
        ContainerOverrides.Builder containerOverridesBuilder = ContainerOverrides.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("vcpus", targetDepth)) {
                    context.nextToken();
                    containerOverridesBuilder.vcpus((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("memory", targetDepth)) {
                    context.nextToken();
                    containerOverridesBuilder.memory((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("command", targetDepth)) {
                    context.nextToken();
                    containerOverridesBuilder.command(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("environment", targetDepth)) {
                    context.nextToken();
                    containerOverridesBuilder.environment(new ListUnmarshaller((Unmarshaller)KeyValuePairUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ContainerOverrides)containerOverridesBuilder.build();
    }

    public static ContainerOverridesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

