/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.batch.model.JobDefinition;
import software.amazon.awssdk.services.batch.model.JobDefinitionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobDefinitionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
    private final List<JobDefinition> jobDefinitions;
    private final String nextToken;

    private DescribeJobDefinitionsResponse(BuilderImpl builder) {
        this.jobDefinitions = builder.jobDefinitions;
        this.nextToken = builder.nextToken;
    }

    public List<JobDefinition> jobDefinitions() {
        return this.jobDefinitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsResponse)) {
            return false;
        }
        DescribeJobDefinitionsResponse other = (DescribeJobDefinitionsResponse)((Object)obj);
        return Objects.equals(this.jobDefinitions(), other.jobDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobDefinitions() != null) {
            sb.append("JobDefinitions: ").append(this.jobDefinitions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitions": {
                return Optional.of(clazz.cast(this.jobDefinitions()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<JobDefinition> jobDefinitions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsResponse model) {
            this.jobDefinitions(model.jobDefinitions);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobDefinition.Builder> getJobDefinitions() {
            return this.jobDefinitions != null ? (Collection)this.jobDefinitions.stream().map(JobDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(JobDefinition ... jobDefinitions) {
            this.jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        public final void setJobDefinitions(Collection<JobDefinition.BuilderImpl> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copyFromBuilder(jobDefinitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeJobDefinitionsResponse build() {
            return new DescribeJobDefinitionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
        public Builder jobDefinitions(Collection<JobDefinition> var1);

        public Builder jobDefinitions(JobDefinition ... var1);

        public Builder nextToken(String var1);
    }
}

