/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.ComputeEnvironmentOrderMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComputeEnvironmentOrder
implements StructuredPojo,
ToCopyableBuilder<Builder, ComputeEnvironmentOrder> {
    private final Integer order;
    private final String computeEnvironment;

    private ComputeEnvironmentOrder(BuilderImpl builder) {
        this.order = builder.order;
        this.computeEnvironment = builder.computeEnvironment;
    }

    public Integer order() {
        return this.order;
    }

    public String computeEnvironment() {
        return this.computeEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.order());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentOrder)) {
            return false;
        }
        ComputeEnvironmentOrder other = (ComputeEnvironmentOrder)obj;
        return Objects.equals(this.order(), other.order()) && Objects.equals(this.computeEnvironment(), other.computeEnvironment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.order() != null) {
            sb.append("Order: ").append(this.order()).append(",");
        }
        if (this.computeEnvironment() != null) {
            sb.append("ComputeEnvironment: ").append(this.computeEnvironment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "order": {
                return Optional.of(clazz.cast(this.order()));
            }
            case "computeEnvironment": {
                return Optional.of(clazz.cast(this.computeEnvironment()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeEnvironmentOrderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer order;
        private String computeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentOrder model) {
            this.order(model.order);
            this.computeEnvironment(model.computeEnvironment);
        }

        public final Integer getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final String getComputeEnvironment() {
            return this.computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        public ComputeEnvironmentOrder build() {
            return new ComputeEnvironmentOrder(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComputeEnvironmentOrder> {
        public Builder order(Integer var1);

        public Builder computeEnvironment(String var1);
    }
}

