/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.services.batch.model.JQStatus;
import software.amazon.awssdk.services.batch.transform.JobQueueDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobQueueDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobQueueDetail> {
    private final String jobQueueName;
    private final String jobQueueArn;
    private final String state;
    private final String status;
    private final String statusReason;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    public String jobQueueName() {
        return this.jobQueueName;
    }

    public String jobQueueArn() {
        return this.jobQueueArn;
    }

    public String state() {
        return this.state;
    }

    public String status() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobQueueName() == null ? 0 : this.jobQueueName().hashCode());
        hashCode = 31 * hashCode + (this.jobQueueArn() == null ? 0 : this.jobQueueArn().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.computeEnvironmentOrder() == null ? 0 : this.computeEnvironmentOrder().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail)obj;
        if (other.jobQueueName() == null ^ this.jobQueueName() == null) {
            return false;
        }
        if (other.jobQueueName() != null && !other.jobQueueName().equals(this.jobQueueName())) {
            return false;
        }
        if (other.jobQueueArn() == null ^ this.jobQueueArn() == null) {
            return false;
        }
        if (other.jobQueueArn() != null && !other.jobQueueArn().equals(this.jobQueueArn())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.computeEnvironmentOrder() == null ^ this.computeEnvironmentOrder() == null) {
            return false;
        }
        return other.computeEnvironmentOrder() == null || other.computeEnvironmentOrder().equals(this.computeEnvironmentOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobQueueName() != null) {
            sb.append("JobQueueName: ").append(this.jobQueueName()).append(",");
        }
        if (this.jobQueueArn() != null) {
            sb.append("JobQueueArn: ").append(this.jobQueueArn()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(this.computeEnvironmentOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobQueueDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobQueueName;
        private String jobQueueArn;
        private String state;
        private String status;
        private String statusReason;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            this.setJobQueueName(model.jobQueueName);
            this.setJobQueueArn(model.jobQueueArn);
            this.setState(model.state);
            this.setStatus(model.status);
            this.setStatusReason(model.statusReason);
            this.setPriority(model.priority);
            this.setComputeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return this.jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JQStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder> getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
        }

        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobQueueDetail> {
        public Builder jobQueueName(String var1);

        public Builder jobQueueArn(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder status(String var1);

        public Builder status(JQStatus var1);

        public Builder statusReason(String var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);
    }
}

